/*
 * SmartGWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * SmartGWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  SmartGWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
 
package com.smartgwt.client.widgets.form.fields;



import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.JSOHelper;
import com.smartgwt.client.util.EnumUtil;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
   /**
    * Form item which renders a Canvas inline in a DynamicForm instance.

    */
public class CanvasItem extends FormItem {

    public static CanvasItem getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        RefDataClass obj = RefDataClass.getRef(jsObj);
        if(obj != null) {
            obj.setJsObj(jsObj);
            return (CanvasItem) obj;
        } else {
            return new CanvasItem(jsObj);
        }
    }


    public CanvasItem(){
        setType("CanvasItem");
    }

    public CanvasItem(JavaScriptObject jsObj){
        super(jsObj);
    }

    public CanvasItem(String name) {
        setName(name);
        setType("CanvasItem");
    }

    public CanvasItem(String name, String title) {
        setName(name);
		setTitle(title);
        setType("CanvasItem");
    }

    // ********************* Properties / Attributes ***********************
            
    /**
    * The canvas that will be displayed inside this item.  You can pass an instance you've &#010 already created, or its global ID as a String.  If none is passed, one will be &#010 auto-created using the overrideable defaults: {@link com.smartgwt.client.widgets.form.fields.CanvasItem#getCanvasProperties canvasProperties} and&#010 {@link com.smartgwt.client.widgets.form.fields.CanvasItem#getCanvasConstructor canvasConstructor}
    *
    * @param canvas canvas Default value is null
    */
    public void setCanvas(Canvas canvas) {
        setAttribute("canvas", canvas.getOrCreateJsObj());
    }
    /**
     * The canvas that will be displayed inside this item.  You can pass an instance you've &#010 already created, or its global ID as a String.  If none is passed, one will be &#010 auto-created using the overrideable defaults: {@link com.smartgwt.client.widgets.form.fields.CanvasItem#getCanvasProperties canvasProperties} and&#010 {@link com.smartgwt.client.widgets.form.fields.CanvasItem#getCanvasConstructor canvasConstructor}
     *
     *
     * @return Canvas
     *
     */
    public Canvas getCanvas()  {
            return Canvas.getOrCreateRef(getAttributeAsJavaScriptObject("canvas"));
    }

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

}



