/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.RequestPermissionException;
import com.google.gwt.http.client.StringValidator;
import com.google.gwt.http.client.XMLHTTPRequest;
import com.google.gwt.user.client.impl.HTTPRequestImpl;
import java.util.HashMap;
import java.util.Map;

public class RequestBuilder {
    public static final Method GET = new Method("GET");
    public static final Method POST = new Method("POST");
    private static final HTTPRequestImpl httpRequest = (HTTPRequestImpl)GWT.create(HTTPRequestImpl.class);
    private RequestCallback callback;
    private Map<String, String> headers;
    private final String httpMethod;
    private String password;
    private String requestData;
    private int timeoutMillis;
    private final String url;
    private String user;

    public RequestBuilder(Method httpMethod, String url) {
        this(httpMethod == null ? null : httpMethod.toString(), url);
    }

    protected RequestBuilder(String httpMethod, String url) {
        StringValidator.throwIfEmptyOrNull("httpMethod", httpMethod);
        StringValidator.throwIfEmptyOrNull("url", url);
        this.httpMethod = httpMethod;
        this.url = url;
    }

    public RequestCallback getCallback() {
        return this.callback;
    }

    public String getHeader(String header) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(header);
    }

    public String getHTTPMethod() {
        return this.httpMethod;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Request send() throws RequestException {
        StringValidator.throwIfNull("callback", this.callback);
        return this.doSend(this.requestData, this.callback);
    }

    public Request sendRequest(String requestData, RequestCallback callback) throws RequestException {
        StringValidator.throwIfNull("callback", callback);
        return this.doSend(requestData, callback);
    }

    public void setCallback(RequestCallback callback) {
        StringValidator.throwIfNull("callback", callback);
        this.callback = callback;
    }

    public void setHeader(String header, String value) {
        StringValidator.throwIfEmptyOrNull("header", header);
        StringValidator.throwIfEmptyOrNull("value", value);
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(header, value);
    }

    public void setPassword(String password) {
        StringValidator.throwIfEmptyOrNull("password", password);
        this.password = password;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException("Timeouts cannot be negative");
        }
        this.timeoutMillis = timeoutMillis;
    }

    public void setUser(String user) {
        StringValidator.throwIfEmptyOrNull("user", user);
        this.user = user;
    }

    private Request doSend(String requestData, RequestCallback callback) throws RequestException {
        JavaScriptObject xmlHttpRequest = httpRequest.createXmlHTTPRequest();
        String openError = this.user != null && this.password != null ? XMLHTTPRequest.open(xmlHttpRequest, this.httpMethod, this.url, true, this.user, this.password) : (this.user != null ? XMLHTTPRequest.open(xmlHttpRequest, this.httpMethod, this.url, true, this.user) : XMLHTTPRequest.open(xmlHttpRequest, this.httpMethod, this.url, true));
        if (openError != null) {
            RequestPermissionException requestPermissionException = new RequestPermissionException(this.url);
            requestPermissionException.initCause(new RequestException(openError));
            throw requestPermissionException;
        }
        this.setHeaders(xmlHttpRequest);
        Request request = new Request(xmlHttpRequest, this.timeoutMillis, callback);
        String sendError = XMLHTTPRequest.send(xmlHttpRequest, request, requestData, callback);
        if (sendError != null) {
            throw new RequestException(sendError);
        }
        return request;
    }

    private void setHeaders(JavaScriptObject xmlHttpRequest) throws RequestException {
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                String errorMessage = XMLHTTPRequest.setRequestHeader(xmlHttpRequest, header.getKey(), header.getValue());
                if (errorMessage == null) continue;
                throw new RequestException(errorMessage);
            }
        } else {
            XMLHTTPRequest.setRequestHeader(xmlHttpRequest, "Content-Type", "text/plain; charset=utf-8");
        }
    }

    public static final class Method {
        private final String name;

        private Method(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

