/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FormElement;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.FiresFormEvents;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormHandlerCollection;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.impl.FormPanelImpl;
import com.google.gwt.user.client.ui.impl.FormPanelImplHost;

public class FormPanel
extends SimplePanel
implements FiresFormEvents,
FormPanelImplHost {
    public static final String ENCODING_MULTIPART = "multipart/form-data";
    public static final String ENCODING_URLENCODED = "application/x-www-form-urlencoded";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static int formId = 0;
    private static FormPanelImpl impl = (FormPanelImpl)GWT.create(FormPanelImpl.class);
    private FormHandlerCollection formHandlers;
    private String frameName;
    private Element synthesizedFrame;

    public static FormPanel wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        FormPanel formPanel = new FormPanel(element);
        formPanel.onAttach();
        RootPanel.detachOnWindowClose(formPanel);
        return formPanel;
    }

    public static FormPanel wrap(Element element, boolean createIFrame) {
        assert (Document.get().getBody().isOrHasChild(element));
        FormPanel formPanel = new FormPanel(element, createIFrame);
        formPanel.onAttach();
        RootPanel.detachOnWindowClose(formPanel);
        return formPanel;
    }

    public FormPanel() {
        this(Document.get().createFormElement(), true);
    }

    public FormPanel(NamedFrame frameTarget) {
        this(frameTarget.getName());
    }

    public FormPanel(String target) {
        super(Document.get().createFormElement());
        this.setTarget(target);
    }

    protected FormPanel(Element element) {
        this(element, false);
    }

    protected FormPanel(Element element, boolean createIFrame) {
        super(element);
        FormElement.as(element);
        if (createIFrame) {
            assert (this.getTarget() == null || this.getTarget().trim().length() == 0) : "Cannot create target iframe if the form's target is already set.";
            this.frameName = "FormPanel_" + ++formId;
            this.setTarget(this.frameName);
            this.sinkEvents(32768);
        }
    }

    public void addFormHandler(FormHandler handler) {
        if (this.formHandlers == null) {
            this.formHandlers = new FormHandlerCollection();
        }
        this.formHandlers.add(handler);
    }

    public String getAction() {
        return this.getFormElement().getAction();
    }

    public String getEncoding() {
        return impl.getEncoding(this.getElement());
    }

    public String getMethod() {
        return this.getFormElement().getMethod();
    }

    public String getTarget() {
        return this.getFormElement().getTarget();
    }

    public boolean onFormSubmit() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            return this.onFormSubmitAndCatch(handler);
        }
        return this.onFormSubmitImpl();
    }

    public void onFrameLoad() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            this.onFrameLoadAndCatch(handler);
        } else {
            this.onFrameLoadImpl();
        }
    }

    public void removeFormHandler(FormHandler handler) {
        if (this.formHandlers != null) {
            this.formHandlers.remove(handler);
        }
    }

    public void setAction(String url) {
        this.getFormElement().setAction(url);
    }

    public void setEncoding(String encodingType) {
        impl.setEncoding(this.getElement(), encodingType);
    }

    public void setMethod(String method) {
        this.getFormElement().setMethod(method);
    }

    public void submit() {
        if (this.formHandlers != null && this.formHandlers.fireOnSubmit(this)) {
            return;
        }
        impl.submit(this.getElement(), this.synthesizedFrame);
    }

    protected void onAttach() {
        super.onAttach();
        if (this.frameName != null) {
            this.createFrame();
            Document.get().getBody().appendChild(this.synthesizedFrame);
            impl.hookEvents(this.synthesizedFrame, this.getElement(), this);
        }
    }

    protected void onDetach() {
        super.onDetach();
        if (this.synthesizedFrame != null) {
            impl.unhookEvents(this.synthesizedFrame, this.getElement());
            Document.get().getBody().removeChild(this.synthesizedFrame);
            this.synthesizedFrame = null;
        }
    }

    Element getSynthesizedIFrame() {
        return this.synthesizedFrame;
    }

    private void createFrame() {
        DivElement dummy = Document.get().createDivElement();
        dummy.setInnerHTML("<iframe src=\"javascript:''\" name='" + this.frameName + "' style='position:absolute;width:0;height:0;border:0'>");
        this.synthesizedFrame = dummy.getFirstChildElement();
    }

    private FormElement getFormElement() {
        return (FormElement)this.getElement().cast();
    }

    private boolean onFormSubmitAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            return this.onFormSubmitImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
            return false;
        }
    }

    private boolean onFormSubmitImpl() {
        if (this.formHandlers != null) {
            return !this.formHandlers.fireOnSubmit(this);
        }
        return true;
    }

    private void onFrameLoadAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            this.onFrameLoadImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private void onFrameLoadImpl() {
        if (this.formHandlers != null) {
            DeferredCommand.addCommand(new Command(){

                public void execute() {
                    FormPanel.this.formHandlers.fireOnComplete(FormPanel.this, impl.getContents(FormPanel.this.synthesizedFrame));
                }
            });
        }
    }

    private void setTarget(String target) {
        this.getFormElement().setTarget(target);
    }
}

