/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.ejb;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.service.ILifecycleConfigurationService;
import java.io.File;
import javax.annotation.security.PermitAll;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@PermitAll
@Service
public class ConfigurationService
implements IConfigurationService,
ILifecycleConfigurationService {
    private String confFolderLocation;
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String CONFIG_FOLDER_RELATIVE_PATH = "conf";
    private static final Logger logger = Logger.getLogger(ConfigurationService.class);

    @Override
    public void start() throws Exception {
        File configFolder = new File(System.getProperty(INSTALL_FOLDER_PROPERTY), CONFIG_FOLDER_RELATIVE_PATH);
        this.confFolderLocation = configFolder.getAbsolutePath();
        logger.debug((Object)("confFolderLocation=" + this.confFolderLocation));
    }

    public File getFile(String relativeFolderPath, String filename) {
        if (relativeFolderPath != null && !relativeFolderPath.equals("")) {
            File folderLocation = new File(this.confFolderLocation, relativeFolderPath);
            logger.debug((Object)("final folderLocation=" + folderLocation.getAbsolutePath()));
            return new File(folderLocation, filename);
        }
        return new File(this.confFolderLocation, filename);
    }

    public String getInstallDirectory() {
        return System.getProperty(INSTALL_FOLDER_PROPERTY);
    }

    public File getFile(String relativeFilePath) {
        return new File(this.confFolderLocation, relativeFilePath);
    }
}

