/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.ldap.ejb;

import com.tandbergtv.neptune.realm.ldap.conf.Entity;
import com.tandbergtv.neptune.realm.ldap.conf.EntityCollection;
import com.tandbergtv.neptune.realm.ldap.conf.EntityProperty;
import com.tandbergtv.neptune.realm.ldap.service.IEntityService;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class EntityService
implements IEntityService {
    protected EntityCollection entityCollection;

    public EntityService(EntityCollection entities) {
        this.entityCollection = entities;
    }

    @Override
    public Entity getEntityConfiguration(Class<?> entityClass) {
        Entity match = null;
        String name = entityClass.getSimpleName();
        if (this.entityCollection != null && this.entityCollection.getEntity() != null) {
            for (Entity entity : this.entityCollection.getEntity()) {
                if (!name.equals(entity.getName())) continue;
                match = entity;
                break;
            }
        }
        return match;
    }

    @Override
    public User createUser(LdapContext context, SearchResult result) throws NamingException {
        User user = this.createUser(result);
        return user;
    }

    @Override
    public Role createRole(LdapContext context, SearchResult result) throws NamingException {
        Role role = this.createRole(result);
        return role;
    }

    private User createUser(SearchResult result) throws NamingException {
        if (result == null) {
            return null;
        }
        Entity entity = this.getEntityConfiguration(User.class);
        Map<String, EntityProperty> propertyMap = this.buildPropertyMap(entity);
        Attributes attributes = result.getAttributes();
        User user = new User();
        user.setExternalKey(result.getNameInNamespace());
        user.setDepartment(this.getStringValue("department", propertyMap, attributes));
        user.setEmail(this.getStringValue("email", propertyMap, attributes));
        user.setEmployeeId(this.getStringValue("employeeId", propertyMap, attributes));
        user.setExtension(this.getStringValue("extension", propertyMap, attributes));
        user.setFirstName(this.getStringValue("firstName", propertyMap, attributes));
        user.setLastName(this.getStringValue("lastName", propertyMap, attributes));
        user.setLocation(this.getStringValue("location", propertyMap, attributes));
        user.setPhone(this.getStringValue("phone", propertyMap, attributes));
        user.setUserName(this.getStringValue("userName", propertyMap, attributes));
        String activeValue = this.getStringValue("active", propertyMap, attributes);
        String format = propertyMap.get("active").getFormat();
        boolean active = activeValue == null || format == null || activeValue.equals(format);
        user.setActive(active);
        return user;
    }

    private Role createRole(SearchResult result) throws NamingException {
        Entity entity = this.getEntityConfiguration(Role.class);
        Map<String, EntityProperty> propertyMap = this.buildPropertyMap(entity);
        Attributes attributes = result.getAttributes();
        Role role = new Role();
        role.setExternalKey(result.getNameInNamespace());
        role.setDescription(this.getStringValue("description", propertyMap, attributes));
        role.setName(this.getStringValue("name", propertyMap, attributes));
        String usersAttrName = propertyMap.get("users").getValue();
        if (usersAttrName != null && usersAttrName.trim().length() > 0) {
            List<Object> values = this.getValues("users", propertyMap, attributes);
            role.setUserCount(Integer.valueOf(values.size()));
        }
        return role;
    }

    private Object getValue(String propertyName, Map<String, EntityProperty> propertyMap, Attributes attributes) throws NamingException {
        Object value = null;
        EntityProperty property = propertyMap.get(propertyName);
        String attributeName = property.getValue();
        if (attributeName == null) {
            return value;
        }
        Attribute attribute = attributes.get(attributeName.trim());
        if (attribute != null) {
            value = attribute.get();
        }
        return value;
    }

    private List<Object> getValues(String propertyName, Map<String, EntityProperty> propertyMap, Attributes attributes) throws NamingException {
        ArrayList<Object> values = new ArrayList<Object>();
        EntityProperty property = propertyMap.get(propertyName);
        String attributeName = property.getValue();
        Attribute attribute = attributes.get(attributeName);
        if (attribute != null) {
            NamingEnumeration<?> valueEnumeration = attribute.getAll();
            while (valueEnumeration.hasMore()) {
                Object value = valueEnumeration.next();
                values.add(value);
            }
        }
        return values;
    }

    private String getStringValue(String propertyName, Map<String, EntityProperty> propertyMap, Attributes attributes) throws NamingException {
        Object value = this.getValue(propertyName, propertyMap, attributes);
        String stringValue = value != null ? value.toString() : null;
        return stringValue;
    }

    private List<String> getStringValues(String propertyName, Map<String, EntityProperty> propertyMap, Attributes attributes) throws NamingException {
        List<Object> values = this.getValues(propertyName, propertyMap, attributes);
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (Object value : values) {
            String stringValue = value != null ? value.toString() : null;
            stringValues.add(stringValue);
        }
        return stringValues;
    }

    private Map<String, EntityProperty> buildPropertyMap(Entity entity) {
        HashMap<String, EntityProperty> propertyMap = new HashMap<String, EntityProperty>();
        for (EntityProperty property : entity.getProperties().getProperty()) {
            propertyMap.put(property.getName(), property);
        }
        return propertyMap;
    }
}

