/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.rolemgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.IRoleValidityService;
import com.tandbergtv.neptune.rolemgmt.service.RoleValidationException;
import com.tandbergtv.neptune.rolemgmt.service.internal.IExternalRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.internal.IInternalRoleManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.aspectj.runtime.internal.AroundClosure;

@Stateless
public class RoleManager
implements IRoleManager {
    @EJB
    IInternalRoleManager internalManager;
    @EJB
    IExternalRoleManager externalManager;
    @EJB
    IUserLdapContext userLdapContext;
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;

    @RolesAllowed(value={"RoleManagement_View"})
    public List<Role> getRoles() {
        return this.getRoleManager().getRoles();
    }

    @RolesAllowed(value={"RoleManagement_View"})
    public Role getRole(RoleKey roleKey) {
        return this.getRoleManager().getRole(roleKey);
    }

    @RolesAllowed(value={"RoleManagement_Create"})
    public Role createRole(Role role) throws ValidationException {
        this.validate(role);
        return this.getRoleManager().createRole(role);
    }

    @RolesAllowed(value={"RoleManagement_Modify"})
    public Role updateRole(Role role) throws ValidationException {
        this.validate(role);
        return this.getRoleManager().updateRole(role);
    }

    @RolesAllowed(value={"RoleManagement_Delete"})
    public boolean deleteRole(RoleKey roleKey) {
        return this.getRoleManager().deleteRole(roleKey);
    }

    @RolesAllowed(value={"RoleManagement_Delete"})
    public boolean deleteRoles(RoleKey ... roleKeys) {
        return this.getRoleManager().deleteRoles(roleKeys);
    }

    @RolesAllowed(value={"RoleManagement_View"})
    public boolean isReadOnly() {
        return this.getRoleManager().isReadOnly();
    }

    private void validateWithComponents(Role role, List<String> validationMessages) throws ValidationException {
        String string = "SELECT permission FROM Permission permission";
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? RoleManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        List permissions = query.getResultList();
        HashMap<Long, Permission> permissionIdMap = new HashMap<Long, Permission>();
        for (Permission perm : permissions) {
            permissionIdMap.put(perm.getId(), perm);
        }
        HashSet<Permission> completePermissionInfo = new HashSet<Permission>();
        for (Permission perm : role.getPermissions()) {
            Permission completePermission = (Permission)permissionIdMap.get(perm.getId());
            completePermissionInfo.add(completePermission);
        }
        role.setPermissions(completePermissionInfo);
        ServiceLoader<IRoleValidityService> roleValidityLoader = ServiceLoader.load(IRoleValidityService.class);
        if (roleValidityLoader != null) {
            for (IRoleValidityService roleValidityProvider : roleValidityLoader) {
                try {
                    roleValidityProvider.validate(role);
                }
                catch (RoleValidationException e) {
                    validationMessages.add(e.getLocalizedMessage());
                }
            }
        }
    }

    private void validate(Role role) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isBlank(role.getName())) {
            validationMessages.add("Name is required.");
        }
        this.validateWithComponents(role, validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IRoleManager getRoleManager() {
        Object manager = null;
        manager = this.userLdapContext.isExternalUserModelEnabled() ? this.externalManager : this.internalManager;
        return manager;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Query createQuery_aroundBody1$advice(RoleManager this_, EntityManager pageTarget, String entityManager, PagingAspect queryString, PageTarget ajc_aroundClosure, EntityManager entityManager2, String string, AroundClosure aroundClosure) {
        void query;
        void builder;
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)queryString).get() == null) {
            AroundClosure aroundClosure2 = aroundClosure;
            String string2 = string;
            EntityManager entityManager3 = entityManager2;
            PageTarget pageTarget2 = ajc_aroundClosure;
            return entityManager3.createQuery(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" ORDER BY ").append(ajc_aroundClosure.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)queryString).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)queryString).get()).booleanValue()) {
            stringBuilder.append("ASC");
        } else {
            stringBuilder.append("DESC");
        }
        AroundClosure aroundClosure3 = aroundClosure;
        String string3 = stringBuilder.toString();
        void var18_15 = builder;
        PageTarget pageTarget3 = ajc_aroundClosure;
        Query query2 = ((EntityManager)var18_15).createQuery(string3);
        query2.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)queryString).get()).intValue());
        query2.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)queryString).get()).intValue());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("select count(").append(ajc_aroundClosure.entityName()).append(") from ").append(ajc_aroundClosure.entityClass()).append(' ').append(ajc_aroundClosure.entityName()).append(" where ").append(ajc_aroundClosure.entityName()).append(" in (").append((String)query).append(')');
        Query query3 = builder.createQuery(stringBuilder2.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)queryString).set(((Long)query3.getSingleResult()).intValue());
        return query2;
    }
}

