/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.server.dispatcher;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.tandbergtv.neptune.ui.framework.client.LoginUiService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.AuthenticationException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.client.security.UserNotLoggedInException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import javax.ejb.EJBAccessException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class NeptuneRemoteServiceDispatcher
extends RemoteServiceServlet {
    private static final int SERVICE_LENGTH = 1;
    Logger LOGGER = Logger.getLogger(NeptuneRemoteServiceDispatcher.class);
    private static final long serialVersionUID = 1L;
    private Map<String, Object> nameToServletClassMap = new HashMap<String, Object>();

    public void init() throws ServletException {
        super.init();
        ServiceLoader<NeptuneRemoteService> loader = ServiceLoader.load(NeptuneRemoteService.class);
        for (NeptuneRemoteService neptuneRemoteService : loader) {
            try {
                this.nameToServletClassMap.put(neptuneRemoteService.getRelativePath(), neptuneRemoteService.getServiceImplementation().newInstance());
            }
            catch (Exception e) {
                this.LOGGER.error((Object)("Unable to register neptune servlet: " + neptuneRemoteService.getRelativePath()), (Throwable)e);
            }
        }
    }

    public String processCall(String payload) throws SerializationException {
        try {
            String responsePayload;
            HttpServletRequest req = this.getThreadLocalRequest();
            String path = req.getRequestURI().substring(req.getContextPath().length() + 1);
            Object serviceImplementation = this.nameToServletClassMap.get(path);
            if (serviceImplementation == null) {
                throw new IncompatibleRemoteServiceException("Servlet for requested path doesn't exist: " + path);
            }
            Locale locale = req.getLocale();
            ClientLocaleProvider.setLocale((Locale)locale);
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, serviceImplementation.getClass(), (SerializationPolicyProvider)this);
            Method serviceMethod = rpcRequest.getMethod();
            SerializationPolicy serializationPolicy = rpcRequest.getSerializationPolicy();
            if (serviceMethod == null) {
                throw new NullPointerException("serviceMethod");
            }
            if (serializationPolicy == null) {
                throw new NullPointerException("serializationPolicy");
            }
            try {
                try {
                    HttpSession httpSession = this.getThreadLocalRequest().getSession(true);
                    if (!(serviceImplementation instanceof LoginUiService) && httpSession.getAttribute("webAuthentication") == null) {
                        return RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)new UserNotLoggedInException(), (SerializationPolicy)serializationPolicy);
                    }
                    Method setSessionMethod = serviceImplementation.getClass().getMethod("setHttpSession", HttpSession.class);
                    setSessionMethod.invoke(serviceImplementation, httpSession);
                }
                catch (SecurityException httpSession) {
                }
                catch (NoSuchMethodException httpSession) {
                    // empty catch block
                }
                Object result = serviceMethod.invoke(serviceImplementation, rpcRequest.getParameters());
                responsePayload = RPC.encodeResponseForSuccess((Method)serviceMethod, (Object)result, (SerializationPolicy)serializationPolicy);
            }
            catch (IllegalAccessException e) {
                SecurityException securityException = new SecurityException(NeptuneRemoteServiceDispatcher.formatIllegalAccessErrorMessage(serviceImplementation, serviceMethod));
                securityException.initCause(e);
                throw securityException;
            }
            catch (IllegalArgumentException e) {
                SecurityException securityException = new SecurityException(NeptuneRemoteServiceDispatcher.formatIllegalArgumentErrorMessage(serviceImplementation, serviceMethod, rpcRequest.getParameters()));
                securityException.initCause(e);
                throw securityException;
            }
            catch (EJBAccessException e) {
                return RPC.encodeResponseForFailure(null, (Throwable)new AuthenticationException());
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    Throwable cause2 = cause.getCause();
                    if (cause2 instanceof EJBAccessException) {
                        return RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)new InsufficientRolesException(), (SerializationPolicy)serializationPolicy);
                    }
                    if (cause2 instanceof NeptuneException) {
                        return RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)cause2, (SerializationPolicy)serializationPolicy);
                    }
                }
                responsePayload = RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)cause, (SerializationPolicy)serializationPolicy);
            }
            return responsePayload;
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.LOGGER.error((Object)"An IncompatibleRemoteServiceException was thrown while processing this call.", (Throwable)ex);
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    private static String formatIllegalAccessErrorMessage(Object target, Method serviceMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to access inaccessible method '");
        sb.append(NeptuneRemoteServiceDispatcher.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(NeptuneRemoteServiceDispatcher.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append("; this is either misconfiguration or a hack attempt");
        return sb.toString();
    }

    private static String formatIllegalArgumentErrorMessage(Object target, Method serviceMethod, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to invoke method '");
        sb.append(NeptuneRemoteServiceDispatcher.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(NeptuneRemoteServiceDispatcher.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append(" with invalid arguments");
        if (args != null && args.length > 0) {
            sb.append(Arrays.asList(args));
        }
        return sb.toString();
    }

    private static String getSourceRepresentation(Method method) {
        return method.toString().replace('$', '.');
    }

    private static String printTypeName(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return "int";
        }
        if (type.equals(Long.TYPE)) {
            return "long";
        }
        if (type.equals(Short.TYPE)) {
            return "short";
        }
        if (type.equals(Byte.TYPE)) {
            return "byte";
        }
        if (type.equals(Character.TYPE)) {
            return "char";
        }
        if (type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.TYPE)) {
            return "double";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return String.valueOf(NeptuneRemoteServiceDispatcher.printTypeName(componentType)) + "[]";
        }
        return type.getName().replace('$', '.');
    }
}

