/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.framework.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.framework.client.Credentials;
import com.tandbergtv.neptune.ui.framework.client.LoginUiService;
import com.tandbergtv.neptune.ui.framework.client.LoginUiServiceAsync;
import com.tandbergtv.neptune.ui.framework.client.ServerInfo;
import com.tandbergtv.neptune.ui.framework.client.ServerInfoProviderService;
import com.tandbergtv.neptune.ui.framework.client.ServerInfoProviderServiceAsync;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.ui.framework.client.impl.EventManager;
import com.tandbergtv.neptune.ui.framework.client.impl.NeptuneSecurityImpl;
import com.tandbergtv.neptune.ui.framework.client.impl.ServiceLoaderImpl;
import com.tandbergtv.neptune.ui.home.client.HomeTabPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.ActionMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.security.UserNotLoggedInException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PasswordTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.TreeTabPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeptuneApplicationImpl
extends NeptuneApplication {
    private static final String STATE_INITIAL = "Home";
    private final List<Component> components;
    private final EventManager eventManager;
    private ServiceLoader serviceLoader;
    private final Map<Class<? extends Throwable>, Runnable> throwableToHandlerMap;
    private final DockContainer mainContainer;
    private TextBox usernameTextBox;
    private final DockContainer imageContainer = new DockContainer();
    private boolean loginPageShown;

    private NeptuneApplicationImpl(List<Component> components) {
        ImageWidget imageWPLogo = new ImageWidget("images/hdr_wplogo.png");
        ImageWidget imageGradient = new ImageWidget("images/hdr_gradient.png");
        ImageWidget imageTTVLogo = new ImageWidget("images/hdr_tandberglogo.png");
        imageWPLogo.setStyleName("wplogo");
        imageGradient.setStyleName("headergradient");
        imageTTVLogo.setStyleName("tandberglogo");
        this.imageContainer.add((Widget)imageWPLogo, DockContainer.WEST);
        this.imageContainer.add((Widget)imageGradient, DockContainer.CENTER);
        this.imageContainer.setCellWidth((Widget)imageGradient, "100%");
        this.imageContainer.add((Widget)imageTTVLogo, DockContainer.EAST);
        this.components = components;
        this.eventManager = new EventManager();
        this.mainContainer = new DockContainer();
        this.mainContainer.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.mainContainer.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainContainer.setHeight("100%");
        this.mainContainer.setStyleName("neptune-main-container");
        this.roleCheck(this.mainContainer);
        this.throwableToHandlerMap = new HashMap<Class<? extends Throwable>, Runnable>();
        this.throwableToHandlerMap.put(UserNotLoggedInException.class, new Runnable(){

            @Override
            public void run() {
                if (!NeptuneApplicationImpl.this.isLoginPageShown()) {
                    NeptuneApplicationImpl.this.mainContainer.clear();
                    NeptuneApplicationImpl.this.populateWithLoginForm(NeptuneApplicationImpl.this.mainContainer);
                    NeptuneApplicationImpl.this.usernameTextBox.setFocus(true);
                }
            }
        });
        this.throwableToHandlerMap.put(InsufficientRolesException.class, new Runnable(){

            @Override
            public void run() {
                Window.alert((String)"You do not have the necessary permission for this operation");
            }
        });
    }

    public static void init(List<Component> components) {
        NeptuneApplication.INSTANCE = new NeptuneApplicationImpl(components);
    }

    public Widget getMainContainer() {
        return this.mainContainer;
    }

    public ServiceLoader getServiceLoader() {
        return this.serviceLoader;
    }

    private synchronized boolean isLoginPageShown() {
        return this.loginPageShown;
    }

    private synchronized void setLoginPageShown(boolean loginPageShown) {
        this.loginPageShown = loginPageShown;
    }

    private void roleCheck(final DockContainer mainContainer) {
        LoginUiServiceAsync async = (LoginUiServiceAsync)GWT.create(LoginUiService.class);
        async.getCredentials(new AsyncCallback<Credentials>(){

            public void onFailure(Throwable caught) {
                if (!NeptuneApplicationImpl.this.isLoginPageShown()) {
                    NeptuneApplicationImpl.this.populateWithLoginForm(mainContainer);
                    NeptuneApplicationImpl.this.usernameTextBox.setFocus(true);
                }
            }

            public void onSuccess(Credentials result) {
                NeptuneSecurityImpl security = new NeptuneSecurityImpl(result.getUsername(), result.getRoles());
                NeptuneApplicationImpl.this.loadServerInfo(mainContainer, security);
                DOM.createIFrame();
            }
        });
    }

    private void populateWithLoginForm(final DockContainer mainContainer) {
        this.setLoginPageShown(true);
        final TextBoxWidget usernameWidget = new TextBoxWidget();
        this.usernameTextBox = usernameWidget;
        final PasswordTextBoxWidget passwordWidget = new PasswordTextBoxWidget();
        NeptuneConstants constants = (NeptuneConstants)GWT.create(NeptuneConstants.class);
        final ButtonWidget loginButton = new ButtonWidget(constants.login(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoginUiServiceAsync async = (LoginUiServiceAsync)GWT.create(LoginUiService.class);
                async.login(usernameWidget.getText(), passwordWidget.getText(), new AsyncCallback<List<String>>(){

                    public void onFailure(Throwable caught) {
                        Window.alert((String)"Invalid username/password");
                    }

                    public void onSuccess(List<String> result) {
                        NeptuneApplicationImpl.this.setLoginPageShown(false);
                        NeptuneSecurityImpl security = new NeptuneSecurityImpl(usernameWidget.getText(), result);
                        mainContainer.clear();
                        NeptuneApplicationImpl.this.loadServerInfo(mainContainer, security);
                    }
                });
            }
        });
        passwordWidget.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getCharCode() == '\r') {
                    loginButton.click();
                }
            }
        });
        loginButton.addStyleDependentName("action-button");
        FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_RIGHT);
        formContainer.addRow(new LabelWidget(constants.username()), (Widget)usernameWidget);
        formContainer.addRow(new LabelWidget(constants.password()), (Widget)passwordWidget);
        formContainer.addButton(loginButton);
        mainContainer.add((Widget)this.imageContainer, DockContainer.NORTH);
        HorizontalContainer decoratedLoginForm = new HorizontalContainer();
        decoratedLoginForm.add((Widget)new ImageWidget("images/lock.gif"));
        decoratedLoginForm.add((Widget)formContainer);
        mainContainer.add((Widget)decoratedLoginForm, DockContainer.CENTER);
        mainContainer.setCellHorizontalAlignment((Widget)decoratedLoginForm, HasHorizontalAlignment.ALIGN_CENTER);
        this.usernameTextBox.setFocus(true);
    }

    private void loadServerInfo(final DockContainer mainContainer, final NeptuneSecurity security) {
        ServerInfoProviderServiceAsync async = (ServerInfoProviderServiceAsync)GWT.create(ServerInfoProviderService.class);
        async.getInfo(new AsyncCallback<ServerInfo>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onSuccess(ServerInfo result) {
                NeptuneApplicationImpl.this.populateWithTabPage(mainContainer, security, result);
            }
        });
    }

    private void populateWithTabPage(final DockContainer mainContainer, final NeptuneSecurity security, ServerInfo info) {
        this.serviceLoader = new ServiceLoaderImpl(this.components, security);
        for (Component component : this.components) {
            component.init((EventListenerRegistry)this.eventManager, (EventSink)this.eventManager, this.serviceLoader, info.getInfoMap());
        }
        if (info.getErrorMsgs() != null && !info.getErrorMsgs().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String e : info.getErrorMsgs()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(e);
            }
            Window.alert((String)sb.toString());
        }
        TreeTabPanel.AnchorChangeListener frameworkAnchorChangeListener = new TreeTabPanel.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                History.newItem((String)anchor, (boolean)false);
            }
        };
        TreeTabPanel treeTabPanel = new TreeTabPanel(frameworkAnchorChangeListener, security.getUsername());
        treeTabPanel.addListener(new TreeTabPanel.Listener(){

            public void tabChanged(TreeTabPanel.TabNode tabNode) {
                History.newItem((String)tabNode.getToken(), (boolean)false);
            }
        });
        TabHistoryListener tabHistoryListener = new TabHistoryListener(treeTabPanel);
        final HandlerRegistration registration = History.addValueChangeHandler((ValueChangeHandler)tabHistoryListener);
        String token = History.getToken().length() == 0 ? STATE_INITIAL : History.getToken();
        History.newItem((String)token, (boolean)false);
        TreeTabPanelNodeProducer producer = new TreeTabPanelNodeProducer(treeTabPanel.getRootMenu());
        final ArrayList portletFactories = new ArrayList();
        for (Component component : this.components) {
            List list = component.listPortlets(security);
            if (list == null) continue;
            portletFactories.addAll(list);
        }
        ArrayList<Object> tabs = new ArrayList<Object>();
        WidgetMenuItem homeTabFactory = new WidgetMenuItem(STATE_INITIAL, new WidgetFactory(){

            public Widget getInstance() {
                return new HomeTabPanel(security, portletFactories);
            }

            public void release(Widget widget) {
            }
        });
        tabs.add(homeTabFactory);
        for (Component component : this.components) {
            tabs.addAll(component.listTabs(security));
        }
        Collections.sort(tabs, new Comparator<MenuItemBase>(){

            @Override
            public int compare(MenuItemBase o1, MenuItemBase o2) {
                if (o1 instanceof MenuItemProxy && !(o2 instanceof MenuItemProxy)) {
                    return 1;
                }
                return 0;
            }
        });
        tabs.add(new ActionMenuItem("Logout", new Runnable(){

            @Override
            public void run() {
                ((LoginUiServiceAsync)GWT.create(LoginUiService.class)).logout(new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        Window.alert((String)("Logout failed. Reason: " + caught.getMessage()));
                    }

                    public void onSuccess(Void result) {
                        Window.alert((String)"Logged out successfully.\n For security reasons, please close this window if it did not close automatically.");
                        NeptuneApplicationImpl.closeWindow();
                        History.newItem(null, (boolean)false);
                        registration.removeHandler();
                        mainContainer.clear();
                        NeptuneApplicationImpl.this.populateWithLoginForm(mainContainer);
                        NeptuneApplicationImpl.this.usernameTextBox.setFocus(true);
                    }
                });
            }
        }));
        for (MenuItemBase menuItemBase : tabs) {
            menuItemBase.accept((MenuItemBase.Visitor)producer);
        }
        treeTabPanel.setActiveTab(token);
        VerticalContainer verticalContainer = new VerticalContainer();
        verticalContainer.setStyleName("neptune-tab-container");
        verticalContainer.add((Widget)this.imageContainer);
        verticalContainer.setCellHorizontalAlignment((Widget)this.imageContainer, VerticalContainer.ALIGN_LEFT);
        verticalContainer.add((Widget)treeTabPanel);
        treeTabPanel.doLayout();
        mainContainer.add((Widget)verticalContainer, DockContainer.CENTER);
    }

    public static native void closeWindow();

    public boolean handleThrowable(Throwable caught) {
        Runnable runnable = this.throwableToHandlerMap.get(caught.getClass());
        if (runnable == null) {
            return false;
        }
        runnable.run();
        return true;
    }

    public <T extends Component> T getComponent(Class<T> componentClass) {
        if (this.components == null) {
            return null;
        }
        for (Component component : this.components) {
            if (!component.getClass().equals(componentClass)) continue;
            return (T)component;
        }
        return null;
    }

    private final class TabHistoryListener
    implements ValueChangeHandler<String> {
        private final TreeTabPanel tabPanel;

        private TabHistoryListener(TreeTabPanel tabPanel) {
            this.tabPanel = tabPanel;
        }

        public void onValueChange(ValueChangeEvent<String> event) {
            String anchor = (String)event.getValue();
            if (anchor == null || anchor.trim().length() == 0) {
                anchor = NeptuneApplicationImpl.STATE_INITIAL;
            }
            this.tabPanel.setActiveTab(anchor);
        }
    }

    private final class TreeTabPanelNodeProducer
    implements MenuItemBase.Visitor {
        private final TreeTabPanel.MenuNode menuNode;

        private TreeTabPanelNodeProducer(TreeTabPanel.MenuNode menuNode) {
            this.menuNode = menuNode;
        }

        public void visit(WidgetMenuItem menuitem) {
            final TreeTabPanel.TabNode tabNode = this.menuNode.addTabNode(menuitem.getName(), menuitem.getDisplayName(), menuitem.getWidgetFactory(), (TreeTabPanel.AnchorChangeListener)new ForwardingAnchorChangeListener(menuitem));
            menuitem.setReverseAnchorChangeListener(new WidgetMenuItem.AnchorChangeListener(){

                public void anchorChanged(String anchor) {
                    tabNode.getReverseAnchorChangeListener().anchorChanged(anchor);
                }
            });
        }

        public void visit(GroupMenuItem menu) {
            TreeTabPanel.MenuNode subMenuNode = this.menuNode.addMenuNode(menu.getName(), menu.getDisplayName());
            for (MenuItemBase menuitem : menu.getSubPanels()) {
                menuitem.accept((MenuItemBase.Visitor)new TreeTabPanelNodeProducer(subMenuNode));
            }
        }

        public void visit(ActionMenuItem action) {
            this.menuNode.addActionNode(action.getName(), action.getDisplayName(), action.getRunnable());
        }

        public void visit(MenuItemProxy proxy) {
            TreeTabPanel.MenuNode node = this.menuNode.getMenuNode(proxy.getName());
            if (node == null) {
                node = this.menuNode.addMenuNode(proxy.getName(), proxy.getDisplayName());
            }
            for (MenuItemBase item : proxy.getItems()) {
                item.accept((MenuItemBase.Visitor)new TreeTabPanelNodeProducer(node));
            }
        }

        private final class ForwardingAnchorChangeListener
        implements TreeTabPanel.AnchorChangeListener {
            private final WidgetMenuItem menuitem;

            private ForwardingAnchorChangeListener(WidgetMenuItem panel) {
                this.menuitem = panel;
            }

            public void anchorChanged(String anchor) {
                this.menuitem.getAnchorChangeListener().anchorChanged(anchor);
            }
        }
    }
}

