/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.framework.server;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.ui.framework.client.Credentials;
import com.tandbergtv.neptune.ui.framework.client.LoginUiService;
import com.tandbergtv.neptune.ui.framework.server.Constants;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.AuthenticationException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class LoginUiServiceImpl
implements LoginUiService,
NeptuneRemoteService,
Constants {
    private static final long serialVersionUID = 1L;
    Logger logger = Logger.getLogger(LoginUiServiceImpl.class);
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private HttpSession httpSession;

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public String getRelativePath() {
        return "service/loginService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private List<String> getRoles() throws NeptuneException {
        if (this.getWebAuthentication() == null) {
            throw new AuthenticationException();
        }
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(this.authorizationService.getAuthorizedRoles());
        return roles;
    }

    private WebAuthentication getWebAuthentication() {
        return (WebAuthentication)this.httpSession.getAttribute("webAuthentication");
    }

    private void setWebAuthentication(WebAuthentication webAuthentication) {
        this.httpSession.setAttribute("webAuthentication", (Object)webAuthentication);
    }

    private void setUsername(String username) {
        this.httpSession.setAttribute("username", (Object)username);
    }

    @Override
    public List<String> login(String username, String password) throws NeptuneException {
        this.invalidateHttpSession();
        WebAuthentication webAuthentication = new WebAuthentication();
        if (!webAuthentication.login(username, (Object)password)) {
            this.logger.warn((Object)("Login failed for " + username + ", on " + new Date()));
            throw new AuthenticationException();
        }
        this.setWebAuthentication(webAuthentication);
        this.setUsername(username);
        this.logger.info((Object)("Successful login for " + username + ", on " + new Date()));
        return this.getRoles();
    }

    private void invalidateHttpSession() {
        if (this.getWebAuthentication() != null) {
            this.httpSession.invalidate();
        }
    }

    @Override
    public void logout() {
        String username = (String)this.httpSession.getAttribute("username");
        this.invalidateHttpSession();
        if (username != null) {
            this.logger.info((Object)("Successful logout for " + username + ", on " + new Date()));
        } else {
            this.logger.info((Object)"User has already been logged out.");
        }
    }

    @Override
    public Credentials getCredentials() throws NeptuneException {
        if (this.getWebAuthentication() == null) {
            throw new AuthenticationException();
        }
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(this.authorizationService.getAuthorizedRoles());
        String username = this.authorizationService.getUserName();
        return new Credentials(username, roles);
    }
}

