/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiModule;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiPermission;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ModulePanel
extends Composite {
    private Grid grid;
    private final Map<Long, CheckBoxWidget> map = new HashMap<Long, CheckBoxWidget>();

    public ModulePanel(List<UiModule> model) {
        int maxPermissionsCount = 0;
        for (UiModule module : model) {
            int permissionsCount = module.getPermissions().size();
            if (permissionsCount <= maxPermissionsCount) continue;
            maxPermissionsCount = permissionsCount;
        }
        this.grid = new Grid(model.size(), maxPermissionsCount + 1);
        int rowCount = 0;
        for (UiModule module : model) {
            this.grid.setWidget(rowCount, 0, (Widget)new LabelWidget(String.valueOf(module.getDisplayName()) + ":"));
            int columnCount = 1;
            for (UiPermission permission : module.getPermissions()) {
                CheckBoxWidget checkBox = new CheckBoxWidget(permission.getDisplayName(), false);
                this.grid.setWidget(rowCount, columnCount, (Widget)checkBox);
                this.map.put(permission.getId(), checkBox);
                ++columnCount;
            }
            ++rowCount;
        }
        this.initWidget((Widget)this.grid);
    }

    public void setData(Collection<Long> data) {
        for (CheckBoxWidget checkBox : this.map.values()) {
            checkBox.setValue(Boolean.valueOf(false));
        }
        for (Long permissionId : data) {
            this.map.get(permissionId).setValue(Boolean.valueOf(true));
        }
    }

    public Collection<Long> getData() {
        ArrayList<Long> checked = new ArrayList<Long>();
        for (Long key : this.map.keySet()) {
            if (!this.map.get(key).getValue().booleanValue()) continue;
            checked.add(key);
        }
        return checked;
    }

    final class PermissionPanel
    extends HorizontalPanel {
        private Map<Long, CheckBox> idToCheckBox;

        public PermissionPanel(UiModule module) {
            super.setSpacing(3);
        }

        public Map<Long, CheckBox> getIdToCheckBoxMap() {
            return this.idToCheckBox;
        }
    }
}

