/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.ui.realm.client.event.RoleAddedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.RoleDeletedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.RoleEventBase;
import com.tandbergtv.neptune.ui.realm.client.event.RoleUpdatedEvent;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.role.ModulePanel;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleDeletionException;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleMenuAnchorChangeListener;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiModule;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleKey;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleKeySerializer;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleList;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.event.NeptuneEvent;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelIntegerView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class RoleTableProvider {
    private final EventSink eventSink;
    private final RoleUiServiceAsync roleService = (RoleUiServiceAsync)GWT.create(RoleUiService.class);
    private final RoleDataProvider dataProvider;
    private final PageFeature pageFeature;
    private final RoleDetailFeature detailFeature;
    private final SortFeatureImpl<UiRoleKey, RoleRecord> sortFeature;
    private final BookmarkFeature bookmarkFeature;
    private final Table<UiRoleKey, RoleRecord> table;
    private final WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private NeptuneSecurity security;
    private static final String VIEW_PERMISSION = "RoleManagement_View";
    private static final String CREATE_PERMISSION = "RoleManagement_Create";
    private static final String MODIFY_PERMISSION = "RoleManagement_Modify";
    private static final String DELETE_PERMISSION = "RoleManagement_Delete";

    public RoleTableProvider(EventSink eventSink, EventListenerRegistry eventListenerRegistry, NeptuneSecurity security) {
        this.eventSink = eventSink;
        this.security = security;
        this.dataProvider = new RoleDataProvider();
        this.table = new Table((DataProvider)this.dataProvider);
        this.pageFeature = new PageFeatureImpl();
        this.detailFeature = new RoleDetailFeature();
        this.sortFeature = new SortFeatureImpl((Column)this.dataProvider.nameColumn, SortOrder.ASCENDING);
        this.sortFeature.getSortableColumns().add(this.dataProvider.nameColumn);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature(this.pageFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.anchorChangeListener = new RoleMenuAnchorChangeListener(this);
    }

    public void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeNotifier) {
        this.table.setAnchorChangeNotifier(anchorChangeNotifier);
    }

    public Table<UiRoleKey, RoleRecord> getTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public final class RoleDataProvider
    implements DataProvider<UiRoleKey, RoleRecord> {
        private final List<Column<?, RoleRecord>> columns = new ArrayList();
        private ColumnBase<String, RoleRecord> nameColumn = new ColumnBase<String, RoleRecord>("name", "Name"){

            public View<String> getView(RoleRecord record) {
                return new LabelStringView(record.getRole().getName());
            }
        };
        private ColumnBase<Integer, RoleRecord> userCountColumn;
        private ColumnBase<String, RoleRecord> descriptionColumn;
        private ColumnBase<Integer, RoleRecord> permissionsColumn;

        public RoleDataProvider() {
            this.columns.add((Column<?, RoleRecord>)this.nameColumn);
            this.userCountColumn = new ColumnBase<Integer, RoleRecord>("userCount", "User Count"){

                public View<Integer> getView(RoleRecord record) {
                    return new LabelIntegerView(record.getRole().getUserCount());
                }
            };
            this.columns.add((Column<?, RoleRecord>)this.userCountColumn);
            this.descriptionColumn = new ColumnBase<String, RoleRecord>("description", "Description"){

                public View<String> getView(RoleRecord record) {
                    return new LabelStringView(record.getRole().getDescription());
                }
            };
            this.columns.add((Column<?, RoleRecord>)this.descriptionColumn);
            this.permissionsColumn = new ColumnBase<Integer, RoleRecord>("permissions", "Permission Count"){

                public View<Integer> getView(RoleRecord record) {
                    return new LabelIntegerView(Integer.valueOf(record.getRole().getPermissionIds().size()));
                }
            };
            this.columns.add((Column<?, RoleRecord>)this.permissionsColumn);
        }

        public List<Column<?, RoleRecord>> getColumns() {
            return this.columns;
        }

        public void getRecords(final AsyncCallback<List<RoleRecord>> callback) {
            int length = RoleTableProvider.this.pageFeature.getPageSize();
            int start = (RoleTableProvider.this.pageFeature.getPageNumber() - 1) * length;
            if (start < 0) {
                start = 0;
            }
            RoleTableProvider.this.roleService.listRoles(start, length, RoleTableProvider.this.sortFeature.getSortColumnName(), RoleTableProvider.this.sortFeature.isAscending(), (AsyncCallback<UiRoleList>)new NeptuneAsyncCallback<UiRoleList>(){

                public void onNeptuneFailure(Throwable caught) {
                    RoleTableProvider.this.pageFeature.setRecordCount(-1);
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UiRoleList result) {
                    ArrayList<RoleRecord> records = new ArrayList<RoleRecord>();
                    for (UiRole role : result.getRoles()) {
                        records.add(new RoleRecord(role));
                    }
                    RoleTableProvider.this.pageFeature.setRecordCount(result.getTotal());
                    callback.onSuccess(records);
                }
            });
        }

        public void initialize(final AsyncCallback<Void> callback) {
            RoleTableProvider.this.roleService.getModules((AsyncCallback<List<UiModule>>)new NeptuneAsyncCallback<List<UiModule>>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(List<UiModule> modules) {
                    ((RoleTableProvider)((RoleDataProvider)RoleDataProvider.this).RoleTableProvider.this).detailFeature.modules = modules;
                    callback.onSuccess(null);
                }
            });
        }

        public boolean isCheckboxEnabled() {
            return RoleTableProvider.this.security.isUserInRole(RoleTableProvider.DELETE_PERMISSION);
        }

        public boolean isRecordCountEnabled() {
            return true;
        }

        public void getRecord(UiRoleKey key, final AsyncCallback<RoleRecord> callback) {
            RoleTableProvider.this.roleService.getRole(key, (AsyncCallback<UiRole>)new NeptuneAsyncCallback<UiRole>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UiRole result) {
                    callback.onSuccess((Object)new RoleRecord(result));
                }
            });
        }
    }

    public final class RoleDetailFeature
    extends AbstractDetailFeature<UiRoleKey, RoleRecord> {
        protected List<UiModule> modules;
        private RealmConstants constants;

        public RoleDetailFeature() {
            super((KeySerializer)new UiRoleKeySerializer());
            this.constants = (RealmConstants)GWT.create(RealmConstants.class);
        }

        public void delete(final List<RoleRecord> records, final AsyncCallback<Void> callback) {
            if (records.size() == 0) {
                callback.onFailure((Throwable)((Object)new RoleDeletionException(this.constants.noRoleCheckBoxSelected())));
            }
            ArrayList<UiRoleKey> roleKeys = new ArrayList<UiRoleKey>();
            for (RoleRecord record : records) {
                roleKeys.add(record.getRole().getKey());
            }
            RoleTableProvider.this.roleService.deleteRoles((List<UiRoleKey>)roleKeys, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(Void result) {
                    for (RoleRecord record : records) {
                        RoleTableProvider.this.eventSink.fireEvent((NeptuneEvent)new RoleDeletedEvent(record.getRole()));
                    }
                    callback.onSuccess(null);
                }
            });
        }

        public void getNew(AsyncCallback<RoleRecord> callback) {
            callback.onSuccess((Object)new RoleRecord(new UiRole()));
        }

        public DetailView<UiRoleKey, RoleRecord> getView(RoleRecord record, DetailViewCallback<UiRoleKey, RoleRecord> callback) {
            RoleRecordDetailView roleRecordDetailView = new RoleRecordDetailView(record, callback);
            if (record.getKey().isValueAssigned()) {
                roleRecordDetailView.setSaveAllowed(RoleTableProvider.this.security.isUserInRole(RoleTableProvider.MODIFY_PERMISSION));
            } else {
                roleRecordDetailView.setSaveAllowed(RoleTableProvider.this.security.isUserInRole(RoleTableProvider.CREATE_PERMISSION));
            }
            return roleRecordDetailView;
        }

        public boolean hasDetailLink(Column<?, RoleRecord> column) {
            if (RoleTableProvider.this.security.isUserInRole(RoleTableProvider.VIEW_PERMISSION) || RoleTableProvider.this.security.isUserInRole(RoleTableProvider.MODIFY_PERMISSION)) {
                return column.getName().equals("name");
            }
            return false;
        }

        public void save(final RoleRecord record, final AsyncCallback<Void> callback) {
            final UiRole role = record.getRole();
            RoleTableProvider.this.roleService.save(role, (AsyncCallback<UiRoleKey>)new NeptuneAsyncCallback<UiRoleKey>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UiRoleKey userId) {
                    RoleEventBase event = role.getId() == null ? new RoleAddedEvent(role) : new RoleUpdatedEvent(record.getRole());
                    record.getRole().setKey(userId);
                    RoleTableProvider.this.eventSink.fireEvent((NeptuneEvent)event);
                    callback.onSuccess(null);
                }
            });
        }

        public boolean showCreateButton() {
            return RoleTableProvider.this.security.isUserInRole(RoleTableProvider.CREATE_PERMISSION);
        }

        public boolean showDeleteButton() {
            return RoleTableProvider.this.security.isUserInRole(RoleTableProvider.DELETE_PERMISSION);
        }

        private final class RoleRecordDetailView
        implements DetailView<UiRoleKey, RoleRecord> {
            private static final String STYLE_VALIDATION_MESSAGE = "realm-validationFailure-message";
            private final RoleRecord record;
            private final LabelWidget errorMessageLabel;
            private final TextBoxWidget nameBox;
            private final TextBoxWidget descriptionBox;
            private final TextBoxWidget userCountBox;
            private final ModulePanel modulePanel;
            private final FormContainer mainContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
            private final VerticalContainer headerAndMainContainer = new VerticalContainer();
            NeptuneConstants constants = (NeptuneConstants)GWT.create(NeptuneConstants.class);
            private ButtonWidget saveButton;
            private ButtonWidget revertButton;

            public RoleRecordDetailView(RoleRecord record, final DetailViewCallback<UiRoleKey, RoleRecord> callback) {
                this.record = record;
                this.errorMessageLabel = new LabelWidget();
                this.errorMessageLabel.setStyleName(STYLE_VALIDATION_MESSAGE);
                this.nameBox = new TextBoxWidget();
                this.descriptionBox = new TextBoxWidget();
                this.userCountBox = new TextBoxWidget();
                this.userCountBox.setReadOnly(true);
                this.modulePanel = new ModulePanel(RoleDetailFeature.this.modules);
                this.mainContainer.addRow("Name:", (Widget)this.nameBox, true);
                this.mainContainer.addRow("User Count:", (Widget)this.userCountBox);
                this.mainContainer.addRow("Description:", (Widget)this.descriptionBox);
                this.mainContainer.addRow("Permissions:", (Widget)this.modulePanel);
                this.saveButton = new ButtonWidget("Save", new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RoleRecordDetailView.this.errorMessageLabel.setText(null);
                        callback.save((DetailView)RoleRecordDetailView.this);
                    }
                });
                this.saveButton.addStyleDependentName("commit-button");
                this.mainContainer.addButton(this.saveButton);
                ButtonWidget cancelButton = new ButtonWidget("Cancel", new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RoleRecordDetailView.this.errorMessageLabel.setText(null);
                        callback.cancel((DetailView)RoleRecordDetailView.this);
                    }
                });
                cancelButton.addStyleDependentName("dataloss-button");
                this.mainContainer.addButton(cancelButton);
                this.revertButton = new ButtonWidget("Revert", new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RoleRecordDetailView.this.errorMessageLabel.setText(null);
                        callback.revert((DetailView)RoleRecordDetailView.this);
                    }
                });
                this.revertButton.addStyleDependentName("dataloss-button");
                this.mainContainer.addButton(this.revertButton);
                this.revert();
            }

            public void setSaveAllowed(boolean allowed) {
                this.saveButton.setVisible(allowed);
                this.revertButton.setVisible(allowed);
            }

            public void commit() {
                this.record.getRole().setName(this.nameBox.getText());
                this.record.getRole().setDescription(this.descriptionBox.getText());
                this.record.getRole().setPermissionIds(this.modulePanel.getData());
            }

            public RoleRecord getRecord() {
                return this.record;
            }

            public void revert() {
                this.nameBox.setText(this.record.getRole().getName());
                this.descriptionBox.setText(this.record.getRole().getDescription());
                int userCount = this.record.getRole().getUserCount() != null ? this.record.getRole().getUserCount() : 0;
                this.userCountBox.setText(String.valueOf(userCount));
                this.modulePanel.setData(this.record.getRole().getPermissionIds());
            }

            public Widget getWidget() {
                String roleName = this.record.getRole().getName();
                if (roleName == null) {
                    roleName = "";
                }
                this.headerAndMainContainer.add((Widget)new HeaderPanel(String.valueOf(this.constants.roleDetails()) + " " + roleName));
                this.headerAndMainContainer.add((Widget)this.errorMessageLabel);
                this.headerAndMainContainer.add((Widget)this.mainContainer);
                return this.headerAndMainContainer;
            }

            public void release() {
            }

            public String getStyleName() {
                return null;
            }

            public void saveFailed(Throwable throwable) {
                if (throwable instanceof ValidationException) {
                    ValidationException ve = (ValidationException)throwable;
                    StringBuffer messagesSB = new StringBuffer();
                    for (String message : ve.getValidationMessages()) {
                        messagesSB.append(message).append("\n");
                    }
                    this.errorMessageLabel.setText(messagesSB.toString());
                } else {
                    this.errorMessageLabel.setText(throwable.getLocalizedMessage());
                }
            }
        }
    }

    public static final class RoleRecord
    implements Record<UiRoleKey> {
        private final UiRole role;

        public RoleRecord(UiRole role) {
            this.role = role;
        }

        public UiRole getRole() {
            return this.role;
        }

        public UiRoleKey getKey() {
            return this.role.getKey();
        }
    }
}

