/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiUserKey
implements IsSerializable {
    private static final String ENTRY_SEPARATOR = ":::";
    private Long id;
    private String externalKey;

    public UiUserKey() {
    }

    public UiUserKey(Long id, String externalKey) {
        this.id = id;
        this.externalKey = externalKey;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    public boolean isValueAssigned() {
        return this.externalKey != null || this.id != null;
    }

    public int hashCode() {
        int result = 0;
        result = this.externalKey != null ? this.externalKey.hashCode() + 23 : (this.id != null ? this.id.hashCode() + 7 : super.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UiUserKey)) {
            return false;
        }
        UiUserKey other = (UiUserKey)obj;
        if (this.externalKey != null) {
            return this.externalKey.equals(other.externalKey);
        }
        if (other.externalKey != null) {
            return false;
        }
        if (this.id != null) {
            return this.id.equals(other.id);
        }
        if (other.id != null) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        if (this.id != null) {
            value.append(this.id.toString());
        }
        value.append(ENTRY_SEPARATOR);
        if (this.externalKey != null) {
            value.append(this.externalKey);
        }
        return value.toString();
    }

    public static UiUserKey parse(String userKey) {
        UiUserKey result = new UiUserKey();
        if (userKey == null) {
            throw new RuntimeException("Cannot parse null string to UiUserKey.");
        }
        String[] entries = userKey.split(ENTRY_SEPARATOR, 2);
        if (entries.length != 2) {
            throw new RuntimeException("Cannot parse string to UiUserKey: " + userKey);
        }
        String idValue = entries[0].trim();
        String externalKeyValue = entries[1].trim();
        if (idValue.length() > 0) {
            result.id = Long.parseLong(idValue);
        }
        if (externalKeyValue.length() > 0) {
            result.externalKey = externalKeyValue;
        }
        return result;
    }
}

