/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.event.RoleAddedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.RoleDeletedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.RoleUpdatedEvent;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleList;
import com.tandbergtv.neptune.ui.realm.client.tab.user.RoleListener;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserList;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserRecord;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserTableProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListener;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class UserDataProvider
implements DataProvider<UiUserKey, UserRecord> {
    private final List<Column<?, UserRecord>> columns;
    final ColumnBase<String, UserRecord> usernameColumn;
    final ColumnBase<String, UserRecord> firstNameColumn;
    final ColumnBase<String, UserRecord> lastNameColumn;
    private final UserUiServiceAsync userService = (UserUiServiceAsync)GWT.create(UserUiService.class);
    private final RoleUiServiceAsync roleService = (RoleUiServiceAsync)GWT.create(RoleUiService.class);
    private final EventListenerRegistry eventListenerRegistry;
    private final NeptuneSecurity security;
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<UiUserKey, UserRecord> sortFeature;
    private List<UiRole> roles;
    private final Collection<RoleListener> roleListeners = new ArrayList<RoleListener>();

    public UserDataProvider(EventListenerRegistry eventListenerRegistry, NeptuneSecurity security) {
        this.eventListenerRegistry = eventListenerRegistry;
        this.security = security;
        this.columns = new ArrayList();
        this.usernameColumn = new ColumnBase<String, UserRecord>("userName", "User Name"){

            public View<String> getView(UserRecord record) {
                return new LabelStringView(record.getUser().getUserName());
            }
        };
        this.columns.add((Column<?, UserRecord>)this.usernameColumn);
        this.firstNameColumn = new ColumnBase<String, UserRecord>("firstName", "First Name"){

            public View<String> getView(UserRecord record) {
                return new LabelStringView(record.getUser().getFirstName());
            }
        };
        this.columns.add((Column<?, UserRecord>)this.firstNameColumn);
        this.lastNameColumn = new ColumnBase<String, UserRecord>("lastName", "Last Name"){

            public View<String> getView(UserRecord record) {
                return new LabelStringView(record.getUser().getLastName());
            }
        };
        this.columns.add((Column<?, UserRecord>)this.lastNameColumn);
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public void setSortFeature(SortFeatureImpl<UiUserKey, UserRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    public void addRoleListener(RoleListener roleListener) {
        this.roleListeners.add(roleListener);
    }

    public void removeRoleListener(RoleListener roleListener) {
        this.roleListeners.remove(roleListener);
    }

    public void initialize(final AsyncCallback<Void> callback) {
        this.roleService.listRoles(0, 1000, "name", true, (AsyncCallback<UiRoleList>)new NeptuneAsyncCallback<UiRoleList>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiRoleList result) {
                UserDataProvider.this.roles = new ArrayList<UiRole>(result.getRoles());
                UserDataProvider.this.eventListenerRegistry.registerEventListener(RoleAddedEvent.class, (EventListener)new EventListener<RoleAddedEvent>(){

                    public void eventOccured(RoleAddedEvent event) {
                        UserDataProvider.this.roles.add(event.getRole());
                        for (RoleListener roleListener : UserDataProvider.this.roleListeners) {
                            roleListener.roleAdded(event.getRole());
                        }
                    }
                });
                UserDataProvider.this.eventListenerRegistry.registerEventListener(RoleDeletedEvent.class, (EventListener)new EventListener<RoleDeletedEvent>(){

                    public void eventOccured(RoleDeletedEvent event) {
                        UserDataProvider.this.roles.remove(event.getRole());
                        for (RoleListener roleListener : UserDataProvider.this.roleListeners) {
                            roleListener.roleDeleted(event.getRole());
                        }
                    }
                });
                UserDataProvider.this.eventListenerRegistry.registerEventListener(RoleUpdatedEvent.class, (EventListener)new EventListener<RoleUpdatedEvent>(){

                    public void eventOccured(RoleUpdatedEvent event) {
                        int index = UserDataProvider.this.roles.indexOf(event.getRole());
                        if (index == -1) {
                            UserDataProvider.this.roles.add(event.getRole());
                        } else {
                            UserDataProvider.this.roles.remove(index);
                            UserDataProvider.this.roles.add(index, event.getRole());
                        }
                        for (RoleListener roleListener : UserDataProvider.this.roleListeners) {
                            roleListener.roleUpdated(event.getRole());
                        }
                    }
                });
                callback.onSuccess(null);
            }
        });
    }

    public List<Column<?, UserRecord>> getColumns() {
        return this.columns;
    }

    public List<UiRole> getRoles() {
        return this.roles;
    }

    public void getRecord(UiUserKey key, final AsyncCallback<UserRecord> callback) {
        this.userService.getUser(key, (AsyncCallback<UiUser>)new NeptuneAsyncCallback<UiUser>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiUser result) {
                callback.onSuccess((Object)new UserRecord(result));
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UserRecord>> callback) {
        int length = this.pageFeature.getPageSize();
        int start = (this.pageFeature.getPageNumber() - 1) * length;
        this.userService.listUsers(start, length, this.sortFeature.getSortColumnName(), this.sortFeature.isAscending(), (AsyncCallback<UiUserList>)new NeptuneAsyncCallback<UiUserList>(){

            public void onNeptuneFailure(Throwable caught) {
                UserDataProvider.this.pageFeature.setRecordCount(-1);
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiUserList result) {
                ArrayList<UserRecord> records = new ArrayList<UserRecord>();
                for (UiUser user : result.getUsers()) {
                    records.add(new UserRecord(user));
                }
                UserDataProvider.this.pageFeature.setRecordCount(result.getTotal());
                callback.onSuccess(records);
            }
        });
    }

    public boolean isCheckboxEnabled() {
        return this.security.isUserInRole(UserTableProvider.DELETE_PERMISSION);
    }

    public boolean isRecordCountEnabled() {
        return true;
    }
}

