/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.event.UserAddedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.UserDeletedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.UserUpdatedEvent;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKeySerializer;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserDataProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserDeletionException;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserRecord;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserRecordDetailView;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserTableProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.event.NeptuneEvent;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public final class UserDetailFeature
extends AbstractDetailFeature<UiUserKey, UserRecord> {
    private final UserUiServiceAsync userService = (UserUiServiceAsync)GWT.create(UserUiService.class);
    private RealmConstants constants = (RealmConstants)GWT.create(RealmConstants.class);
    private UserDataProvider dataProvider;
    private EventSink eventSink;
    private NeptuneSecurity security;

    public UserDetailFeature(UserDataProvider dataProvider, EventSink eventSink, NeptuneSecurity security) {
        super((KeySerializer)new UiUserKeySerializer());
        this.dataProvider = dataProvider;
        this.eventSink = eventSink;
        this.security = security;
    }

    public void getNew(AsyncCallback<UserRecord> callback) {
        UserRecord record = new UserRecord(new UiUser());
        callback.onSuccess((Object)record);
    }

    public DetailView<UiUserKey, UserRecord> getView(UserRecord record, DetailViewCallback<UiUserKey, UserRecord> callback) {
        UserRecordDetailView userRecordDetailView = new UserRecordDetailView(record, this.dataProvider, callback);
        if (record.getKey().isValueAssigned()) {
            userRecordDetailView.setSaveAllowed(this.security.isUserInRole(UserTableProvider.MODIFY_PERMISSION));
        } else {
            userRecordDetailView.setSaveAllowed(this.security.isUserInRole(UserTableProvider.CREATE_PERMISSION));
        }
        return userRecordDetailView;
    }

    public void save(final UserRecord record, final AsyncCallback<Void> callback) {
        final UiUser user = record.getUser();
        this.userService.saveUser(user, (AsyncCallback<UiUserKey>)new NeptuneAsyncCallback<UiUserKey>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiUserKey userId) {
                Object neptuneEvent = user.getId() == null ? new UserAddedEvent(user) : new UserUpdatedEvent(record.getUser());
                user.setKey(userId);
                UserDetailFeature.this.eventSink.fireEvent((NeptuneEvent)neptuneEvent);
                callback.onSuccess(null);
            }
        });
    }

    public void delete(final List<UserRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() == 0) {
            callback.onFailure((Throwable)((Object)new UserDeletionException(this.constants.noUserCheckBoxSelected())));
        }
        ArrayList<UiUserKey> userKeys = new ArrayList<UiUserKey>();
        for (UserRecord record : records) {
            userKeys.add(record.getUser().getKey());
        }
        this.userService.deleteUsers(userKeys, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Void result) {
                for (UserRecord record : records) {
                    UserDetailFeature.this.eventSink.fireEvent((NeptuneEvent)new UserDeletedEvent(record.getUser()));
                }
                callback.onSuccess(null);
            }
        });
    }

    public boolean hasDetailLink(Column<?, UserRecord> column) {
        if (this.security.isUserInRole(UserTableProvider.VIEW_PERMISSION) || this.security.isUserInRole(UserTableProvider.MODIFY_PERMISSION)) {
            return column.getName().equals("userName");
        }
        return false;
    }

    public boolean showCreateButton() {
        return this.security.isUserInRole(UserTableProvider.CREATE_PERMISSION);
    }

    public boolean showDeleteButton() {
        return this.security.isUserInRole(UserTableProvider.DELETE_PERMISSION);
    }
}

