/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserNotFoundException;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserRecord;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserTableProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;

class UserMenuAnchorChangeListener
implements WidgetMenuItem.AnchorChangeListener {
    private final UserTableProvider tableProvider;
    private static final String USER_NAME_ANCHOR = "Edit?userName=";
    private final UserUiServiceAsync userService = (UserUiServiceAsync)GWT.create(UserUiService.class);
    private RealmConstants constants = (RealmConstants)GWT.create(RealmConstants.class);

    public UserMenuAnchorChangeListener(UserTableProvider tableProvider) {
        this.tableProvider = tableProvider;
    }

    public void anchorChanged(final String anchor) {
        Table<UiUserKey, UserRecord> table = this.tableProvider.getTable();
        table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(Void result) {
                UserMenuAnchorChangeListener.this.handleAnchorChange(anchor);
            }
        });
    }

    private void handleAnchorChange(String anchor) {
        if (anchor != null && anchor.startsWith(USER_NAME_ANCHOR)) {
            this.tableProvider.getTable().reset();
            final String userName = anchor.substring(USER_NAME_ANCHOR.length());
            this.userService.getUser(userName, (AsyncCallback<UiUser>)new NeptuneAsyncCallback<UiUser>(){

                public void onNeptuneFailure(Throwable caught) {
                    if (caught instanceof UserNotFoundException) {
                        Window.alert((String)(String.valueOf(UserMenuAnchorChangeListener.this.constants.userNotFoundForUserName()) + userName));
                    } else {
                        Window.alert((String)caught.getLocalizedMessage());
                    }
                }

                public void onNeptuneSuccess(UiUser result) {
                    UserMenuAnchorChangeListener.this.tableProvider.getTable().showDetailView((Record)new UserRecord(result));
                }
            });
        } else {
            this.tableProvider.getTable().setAnchor(anchor);
        }
    }
}

