/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.RoleListener;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserDataProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserRecordDetailView
implements DetailView<UiUserKey, UserRecord>,
RoleListener {
    private static final String STYLE_VALIDATION_MESSAGE = "realm-validationFailure-message";
    private final UserRecord record;
    private UserDataProvider dataProvider;
    private final TextBoxWidget usernameBox = new TextBoxWidget();
    private final TextBoxWidget passwordTextBox = new TextBoxWidget();
    private final Map<UiRoleKey, UiRole> keyToRoleMap = new HashMap<UiRoleKey, UiRole>();
    private final ListBoxWidget<UiRole> rolesListBox = new ListBoxWidget();
    private final TextBoxWidget firstNameTextBox = new TextBoxWidget();
    private final TextBoxWidget lastNameTextBox = new TextBoxWidget();
    private final CheckBoxWidget isActiveCheckBox = new CheckBoxWidget("", false);
    private final TextBoxWidget emailTextBox = new TextBoxWidget();
    private final TextBoxWidget employeeIdTextBox = new TextBoxWidget();
    private final TextBoxWidget departmentTextBox = new TextBoxWidget();
    private final TextBoxWidget locationTextBox = new TextBoxWidget();
    private final TextBoxWidget phoneTextBox = new TextBoxWidget();
    private final TextBoxWidget extTextBox = new TextBoxWidget();
    private final LabelWidget errorMessageLabel = new LabelWidget();
    private final FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private final VerticalContainer headerAndMainContainer = new VerticalContainer();
    private NeptuneConstants constants = (NeptuneConstants)GWT.create(NeptuneConstants.class);
    ButtonWidget saveButton;
    ButtonWidget revertButton;

    public UserRecordDetailView(UserRecord record, UserDataProvider dataProvider, final DetailViewCallback<UiUserKey, UserRecord> callback) {
        this.record = record;
        this.dataProvider = dataProvider;
        this.errorMessageLabel.setStyleName(STYLE_VALIDATION_MESSAGE);
        this.rolesListBox.addItem("", null);
        this.usernameBox.setReadOnly(record.getUser().getKey().isValueAssigned());
        dataProvider.addRoleListener(this);
        for (UiRole role : dataProvider.getRoles()) {
            this.roleAdded(role);
        }
        this.formContainer.addRow("User Name:", (Widget)this.usernameBox, true);
        this.formContainer.addRow("Password:", (Widget)this.passwordTextBox, !record.getUser().getKey().isValueAssigned());
        this.formContainer.addRow("Roles:", this.rolesListBox, true);
        this.formContainer.addRow("First Name:", (Widget)this.firstNameTextBox, true);
        this.formContainer.addRow("Last Name:", (Widget)this.lastNameTextBox, true);
        this.formContainer.addRow("Is Active?:", (Widget)this.isActiveCheckBox);
        this.formContainer.addRow("Email:", (Widget)this.emailTextBox, true);
        this.formContainer.addRow("Employee ID:", (Widget)this.employeeIdTextBox, true);
        this.formContainer.addRow("Department:", (Widget)this.departmentTextBox, true);
        this.formContainer.addRow("Location:", (Widget)this.locationTextBox, true);
        this.formContainer.addRow("Phone:", (Widget)this.phoneTextBox);
        this.formContainer.addRow("Extension:", (Widget)this.extTextBox);
        this.saveButton = new ButtonWidget("Save", new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserRecordDetailView.this.errorMessageLabel.setText(null);
                callback.save((DetailView)UserRecordDetailView.this);
            }
        });
        this.saveButton.addStyleDependentName("commit-button");
        this.formContainer.addButton(this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget("Cancel", new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserRecordDetailView.this.errorMessageLabel.setText(null);
                callback.cancel((DetailView)UserRecordDetailView.this);
            }
        });
        cancelButton.addStyleDependentName("dataloss-button");
        this.formContainer.addButton(cancelButton);
        this.revertButton = new ButtonWidget("Revert", new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserRecordDetailView.this.errorMessageLabel.setText(null);
                callback.revert((DetailView)UserRecordDetailView.this);
            }
        });
        this.revertButton.addStyleDependentName("dataloss-button");
        this.formContainer.addButton(this.revertButton);
        this.revert();
    }

    public void setSaveAllowed(boolean allowed) {
        this.saveButton.setVisible(allowed);
        this.revertButton.setVisible(allowed);
    }

    @Override
    public void roleAdded(UiRole role) {
        this.rolesListBox.addItem(role.getName(), (Object)role);
        this.keyToRoleMap.put(role.getKey(), role);
    }

    @Override
    public void roleDeleted(UiRole role) {
        this.rolesListBox.removeItem((Object)role);
        this.keyToRoleMap.remove(role.getKey());
    }

    @Override
    public void roleUpdated(UiRole role) {
        int index = this.rolesListBox.getIndex((Object)role);
        if (index == -1) {
            this.rolesListBox.addItem(role.getName(), (Object)role);
        } else {
            this.rolesListBox.setItem(role.getName(), (Object)role, index);
        }
    }

    public void commit() {
        this.record.getUser().setUserName(this.usernameBox.getText());
        if (this.passwordTextBox.getText() != null && this.passwordTextBox.getText().trim().length() > 0) {
            this.record.getUser().setChangePassword(true);
            this.record.getUser().setPasswordModifiedDate(new Date());
            this.record.getUser().setPassword(this.passwordTextBox.getText().trim());
        }
        HashSet<UiRoleKey> roleIds = new HashSet<UiRoleKey>();
        int index = 0;
        while (index < this.rolesListBox.getItemCount()) {
            UiRole role;
            if (this.rolesListBox.isItemSelected(index) && (role = (UiRole)this.rolesListBox.getItem(index)) != null) {
                roleIds.add(role.getKey());
            }
            ++index;
        }
        this.record.getUser().setRoleIds(roleIds);
        this.record.getUser().setFirstName(this.firstNameTextBox.getText());
        this.record.getUser().setLastName(this.lastNameTextBox.getText());
        this.record.getUser().setActive(this.isActiveCheckBox.getValue());
        this.record.getUser().setEmail(this.emailTextBox.getText());
        this.record.getUser().setEmployeeId(this.employeeIdTextBox.getText());
        this.record.getUser().setDepartment(this.departmentTextBox.getText());
        this.record.getUser().setLocation(this.locationTextBox.getText());
        this.record.getUser().setPhone(this.phoneTextBox.getText());
        this.record.getUser().setExtension(this.extTextBox.getText());
    }

    public Widget getWidget() {
        String userName = this.record.getUser().getUserName();
        if (userName == null) {
            userName = "";
        }
        this.headerAndMainContainer.add((Widget)new HeaderPanel(String.valueOf(this.constants.userDetails()) + " " + userName));
        this.headerAndMainContainer.add((Widget)this.errorMessageLabel);
        this.headerAndMainContainer.add((Widget)this.formContainer);
        return this.headerAndMainContainer;
    }

    public void revert() {
        this.usernameBox.setText(this.record.getUser().getUserName());
        this.passwordTextBox.setText("");
        Set<UiRoleKey> roleIds = this.record.getUser().getRoleIds();
        this.rolesListBox.setSelectedIndex(-1);
        for (UiRoleKey key : roleIds) {
            int index = this.rolesListBox.getIndex((Object)this.keyToRoleMap.get(key));
            this.rolesListBox.setItemSelected(index, true);
        }
        this.firstNameTextBox.setText(this.record.getUser().getFirstName());
        this.lastNameTextBox.setText(this.record.getUser().getLastName());
        this.isActiveCheckBox.setValue(Boolean.valueOf(this.record.getUser().isActive()));
        this.emailTextBox.setText(this.record.getUser().getEmail());
        this.employeeIdTextBox.setText(this.record.getUser().getEmployeeId());
        this.departmentTextBox.setText(this.record.getUser().getDepartment());
        this.locationTextBox.setText(this.record.getUser().getLocation());
        this.phoneTextBox.setText(this.record.getUser().getPhone());
        this.extTextBox.setText(this.record.getUser().getExtension());
    }

    public void release() {
        this.dataProvider.removeRoleListener(this);
    }

    public UserRecord getRecord() {
        return this.record;
    }

    public String getStyleName() {
        return null;
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            StringBuffer messagesSB = new StringBuffer();
            for (String message : ve.getValidationMessages()) {
                messagesSB.append(message).append("\n");
            }
            this.errorMessageLabel.setText(messagesSB.toString());
        } else {
            this.errorMessageLabel.setText(throwable.getLocalizedMessage());
        }
    }
}

