/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserDataProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserDetailFeature;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserMenuAnchorChangeListener;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserRecord;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class UserTableProvider {
    private final UserDataProvider dataProvider;
    private final PageFeatureImpl pageFeature;
    private final SortFeatureImpl<UiUserKey, UserRecord> sortFeature;
    private final BookmarkFeatureImpl bookmarkFeature;
    private final UserDetailFeature detailFeature;
    private final WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private final Table<UiUserKey, UserRecord> table;
    static String VIEW_PERMISSION = "UserManagement_View";
    static String CREATE_PERMISSION = "UserManagement_Create";
    static String MODIFY_PERMISSION = "UserManagement_Modify";
    static String DELETE_PERMISSION = "UserManagement_Delete";

    public UserTableProvider(EventSink eventSink, EventListenerRegistry eventListenerRegistry, NeptuneSecurity security) {
        this.dataProvider = new UserDataProvider(eventListenerRegistry, security);
        this.table = new Table((DataProvider)this.dataProvider);
        this.pageFeature = new PageFeatureImpl();
        this.detailFeature = new UserDetailFeature(this.dataProvider, eventSink, security);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.usernameColumn, SortOrder.ASCENDING);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.sortFeature.addSortableColumn(this.dataProvider.usernameColumn);
        this.sortFeature.addSortableColumn(this.dataProvider.firstNameColumn);
        this.sortFeature.addSortableColumn(this.dataProvider.lastNameColumn);
        this.dataProvider.setPageFeature(this.pageFeature);
        this.dataProvider.setSortFeature(this.sortFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature((PageFeature)this.pageFeature);
        this.table.addBookmarkFeature((BookmarkFeature)this.bookmarkFeature);
        this.anchorChangeListener = new UserMenuAnchorChangeListener(this);
    }

    public void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeNotifier) {
        this.table.setAnchorChangeNotifier(anchorChangeNotifier);
    }

    public Table<UiUserKey, UserRecord> getTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }
}

