/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.event.ComboBoxListener;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.BasicComboBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class ComboBoxWidget<ValueType>
extends Composite
implements HasFocusHandlers,
HasBlurHandlers,
HasChangeHandlers,
HasSelectionHandlers<ValueType>,
HasHandlers,
HasName,
HasText {
    private SimpleContainer container;
    private ComboBox comboBox;
    private RecordDef recordDefinition;
    private ItemKeyGenerator keyGenerator = new ItemKeyGenerator();
    private static final String ITEM_NAME_FIELD = "itemName";
    private static final String ITEM_VALUE_FIELD = "itemValue";

    public ComboBoxWidget() {
        this.initializeWidget();
        this.initWidget((Widget)this.container);
    }

    private void initializeWidget() {
        this.container = new SimpleContainer();
        this.comboBox = new BasicComboBoxWidget();
        this.comboBox.setMode(ComboBox.LOCAL);
        this.comboBox.setTriggerAction(ComboBox.ALL);
        this.comboBox.setHideLabel(true);
        this.comboBox.setSelectOnFocus(true);
        this.comboBox.setTypeAhead(true);
        this.comboBox.setGrow(true);
        StringFieldDef nameFieldDef = new StringFieldDef(ITEM_NAME_FIELD);
        ObjectFieldDef valueFieldDef = new ObjectFieldDef(ITEM_VALUE_FIELD);
        FieldDef[] fieldDefinitions = new FieldDef[]{nameFieldDef, valueFieldDef};
        this.recordDefinition = new RecordDef(fieldDefinitions);
        Store store = new Store(this.recordDefinition);
        this.comboBox.setStore(store);
        this.comboBox.setDisplayField(ITEM_NAME_FIELD);
        EventDelegator delegator = new EventDelegator();
        this.comboBox.addListener((ComboBoxListener)delegator);
        this.container.add((Widget)this.comboBox);
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((EventHandler)handler, FocusEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((EventHandler)handler, BlurEvent.getType());
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<ValueType> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public String getName() {
        return this.comboBox.getName();
    }

    public void setName(String name) {
        this.comboBox.setName(name);
    }

    public int getTabIndex() {
        return this.comboBox.getTabindex();
    }

    public void setTabIndex(int tabIndex) {
        this.comboBox.setTabIndex(tabIndex);
    }

    public void focus() {
        this.comboBox.focus(true);
    }

    public void expand() {
        this.comboBox.expand();
    }

    public void collapse() {
        this.comboBox.collapse();
    }

    public boolean isExpanded() {
        return this.comboBox.isExpanded();
    }

    public void setEnabled(boolean enable) {
        this.comboBox.setDisabled(!enable);
    }

    public boolean isEnabled() {
        return !this.comboBox.isDisabled();
    }

    public void setEditable(boolean editable) {
        this.comboBox.setEditable(editable);
    }

    public boolean isReadOnly() {
        return this.comboBox.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.comboBox.setReadOnly(readOnly);
    }

    public int getMinHeight() {
        return this.comboBox.getMinHeight();
    }

    public void setMinHeight(int minHeight) {
        this.comboBox.setMinHeight(minHeight);
    }

    public void setMinChars(int minChars) {
        this.comboBox.setMinChars(minChars);
    }

    public int[] getCaretPosition() {
        return this.comboBox.getCaretPosition();
    }

    public void setCaretPosition(int caretStart, int numToSelect) {
        this.comboBox.setCaretPosition(caretStart, numToSelect);
    }

    public void insertAtCaret(String text) {
        this.comboBox.insertAtCaret(text);
    }

    public void selectText() {
        this.comboBox.selectText();
    }

    public void selectText(int start, int end) {
        this.comboBox.selectText(start, end);
    }

    public void setMaxLength(int maxLength) {
        this.comboBox.setMaxLength(maxLength);
    }

    public void setMaxLengthText(String maxLengthText) {
        this.comboBox.setMaxLengthText(maxLengthText);
    }

    public void setMinLength(int minLength) {
        this.comboBox.setMinLength(minLength);
    }

    public void setMinLengthText(String minLengthText) {
        this.comboBox.setMinLengthText(minLengthText);
    }

    public int getHeight() {
        return this.comboBox.getHeight();
    }

    public void setHeight(int height) {
        this.comboBox.setHeight(height);
    }

    public void setHeight(String height) {
        this.comboBox.setHeight(height);
    }

    public int getWidth() {
        return this.comboBox.getWidth();
    }

    public void setWidth(int width) {
        this.comboBox.setWidth(width);
    }

    public void setWidth(String width) {
        this.comboBox.setWidth(width);
    }

    public void setSize(int width, int height) {
        this.comboBox.setSize(width, height);
    }

    public void setSize(String width, String height) {
        this.comboBox.setSize(width, height);
    }

    public void addClass(String cls) {
        this.comboBox.addClass(cls);
    }

    public void removeClass(String cls) {
        this.comboBox.removeClass(cls);
    }

    public void setListClass(String listClass) {
        this.comboBox.setListClass(listClass);
    }

    public void addItem(String itemName, ValueType item) {
        String itemKey = this.keyGenerator.generate();
        Record record = this.createRecord(itemKey, itemName, item);
        this.comboBox.getStore().add(record);
        this.comboBox.autoSize();
    }

    public void insertItem(String itemName, ValueType item, int index) {
        String itemKey = this.keyGenerator.generate();
        Record record = this.createRecord(itemKey, itemName, item);
        this.comboBox.getStore().insert(index, record);
        this.comboBox.autoSize();
    }

    public void setItem(String itemName, ValueType item, int index) {
        this.setItemText(index, itemName);
        this.setItem(index, item);
    }

    public void removeItem(ValueType item) {
        int index = this.getIndex(item);
        if (index > -1) {
            this.removeItemAtIndex(index);
        }
    }

    public void removeItemAtIndex(int index) {
        Record record = this.comboBox.getStore().getAt(index);
        this.comboBox.getStore().remove(record);
        this.comboBox.autoSize();
    }

    public void clear() {
        this.comboBox.clearValue();
        this.comboBox.getStore().removeAll();
        this.keyGenerator.reset();
        this.comboBox.autoSize();
    }

    public int getItemCount() {
        return this.comboBox.getStore().getCount();
    }

    public String getItemText(int index) {
        Record record = this.comboBox.getStore().getAt(index);
        return record.getAsString(ITEM_NAME_FIELD);
    }

    public void setItemText(int index, String text) {
        Record record = this.comboBox.getStore().getAt(index);
        record.beginEdit();
        record.set(ITEM_NAME_FIELD, text);
        record.endEdit();
        this.comboBox.autoSize();
    }

    public ValueType getItem(int index) {
        Record record = this.comboBox.getStore().getAt(index);
        Object item = record.getAsObject(ITEM_VALUE_FIELD);
        return (ValueType)item;
    }

    public void setItem(int index, ValueType value) {
        Record record = this.comboBox.getStore().getAt(index);
        record.beginEdit();
        record.set(ITEM_VALUE_FIELD, value);
        record.endEdit();
    }

    public int getIndex(ValueType item) {
        int itemIndex = -1;
        int index = 0;
        while (index < this.getItemCount()) {
            ValueType currentItemValue = this.getItem(index);
            if (item == currentItemValue || item != null && item.equals(currentItemValue)) {
                itemIndex = index;
                break;
            }
            ++index;
        }
        return itemIndex;
    }

    public int getSelectedIndex() {
        String value = this.comboBox.getValue();
        if (value == null) {
            return -1;
        }
        int selectedIndex = -1;
        int index = 0;
        while (index < this.getItemCount()) {
            String text = this.getItemText(index);
            if (value.equals(text)) {
                selectedIndex = index;
                break;
            }
            ++index;
        }
        return selectedIndex;
    }

    public void setSelectedIndex(int index) {
        this.comboBox.setValue(this.getItemText(index));
    }

    public ValueType getSelectedItem() {
        int index = this.getSelectedIndex();
        return index != -1 ? (ValueType)this.getItem(index) : null;
    }

    public void setSelectedItem(ValueType item) {
        int index = this.getIndex(item);
        if (index > -1) {
            this.setSelectedIndex(index);
        } else {
            this.comboBox.clearValue();
        }
    }

    public boolean isItemSelected() {
        return this.getSelectedIndex() != -1;
    }

    public String getText() {
        return this.comboBox.getValue();
    }

    public void setText(String text) {
        this.comboBox.setValue(text);
    }

    public void clearText() {
        this.comboBox.clearValue();
    }

    private Record createRecord(String key, String name, ValueType value) {
        return this.recordDefinition.createRecord(key, new Object[]{name, value});
    }

    private class EventDelegator
    extends ComboBoxListenerAdapter
    implements ComboBoxListener {
        private EventDelegator() {
        }

        public void onSelect(ComboBox comboBox, Record record, int index) {
            Object selectedItem = ComboBoxWidget.this.getSelectedItem();
            SelectionEvent.fire((HasSelectionHandlers)ComboBoxWidget.this, selectedItem);
        }

        public void onFocus(Field field) {
            NativeEvent nativeEvent = Document.get().createFocusEvent();
            DomEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)ComboBoxWidget.this);
        }

        public void onBlur(Field field) {
            NativeEvent nativeEvent = Document.get().createBlurEvent();
            DomEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)ComboBoxWidget.this);
        }

        public void onChange(Field field, Object newVal, Object oldVal) {
            NativeEvent nativeEvent = Document.get().createChangeEvent();
            DomEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)ComboBoxWidget.this);
        }
    }

    private final class ItemKeyGenerator {
        private long itemCounter;
        private static final String ITEM_KEY_PREFIX = "option-";

        public ItemKeyGenerator() {
            this.reset();
        }

        String generate() {
            return ITEM_KEY_PREFIX + ++this.itemCounter;
        }

        void reset() {
            this.itemCounter = 0L;
        }
    }
}

