/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.SimpleListBoxWidget;
import java.util.HashMap;
import java.util.Map;

public class ListBoxWidget<ValueType>
extends Composite
implements HasName,
Focusable,
HasChangeHandlers,
HasClickHandlers,
HasAllFocusHandlers,
HasAllKeyHandlers,
HasAllMouseHandlers,
INeptuneWidget {
    private ListBox listBox;
    private Map<String, ValueType> items = new HashMap<String, ValueType>();
    private ItemKeyGenerator keyGenerator = new ItemKeyGenerator();

    public ListBoxWidget() {
        this(false);
    }

    public ListBoxWidget(boolean isMultipleSelect) {
        this.listBox = new SimpleListBoxWidget(isMultipleSelect);
        this.initializeWidget();
    }

    private void initializeWidget() {
        this.initWidget((Widget)this.listBox);
    }

    public String getName() {
        return this.listBox.getName();
    }

    public void setName(String name) {
        this.listBox.setName(name);
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((EventHandler)handler, BlurEvent.getType());
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((EventHandler)handler, FocusEvent.getType());
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyDownEvent.getType());
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyPressEvent.getType());
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyUpEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseWheelEvent.getType());
    }

    public int getTabIndex() {
        return this.listBox.getTabIndex();
    }

    public void setTabIndex(int index) {
        this.listBox.setTabIndex(index);
    }

    public void setAccessKey(char key) {
        this.listBox.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.listBox.setFocus(focused);
    }

    public void setEnabled(boolean enabled) {
        this.listBox.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.listBox.isEnabled();
    }

    public void addItem(String itemName, ValueType item) {
        String itemKey = this.keyGenerator.generate();
        this.listBox.addItem(itemName, itemKey);
        this.items.put(itemKey, item);
    }

    public void insertItem(String itemName, ValueType item, int index) {
        String itemKey = this.keyGenerator.generate();
        this.listBox.insertItem(itemName, itemKey, index);
        this.items.put(itemKey, item);
    }

    public void setItem(String itemName, ValueType item, int index) {
        this.setItemText(index, itemName);
        this.setItem(index, item);
    }

    public void removeItem(ValueType item) {
        int index = this.getIndex(item);
        if (index > -1) {
            this.removeItemAtIndex(index);
        }
    }

    public void removeItemAtIndex(int index) {
        String itemKey = this.getItemKey(index);
        this.listBox.removeItem(index);
        this.items.remove(itemKey);
    }

    public void clear() {
        this.listBox.clear();
        this.items.clear();
        this.keyGenerator.reset();
    }

    public int getItemCount() {
        return this.listBox.getItemCount();
    }

    public String getItemText(int index) {
        return this.listBox.getItemText(index);
    }

    public void setItemText(int index, String text) {
        this.listBox.setItemText(index, text);
    }

    public ValueType getItem(int index) {
        String itemKey = this.getItemKey(index);
        return this.items.get(itemKey);
    }

    public void setItem(int index, ValueType value) {
        String itemKey = this.getItemKey(index);
        this.items.put(itemKey, value);
    }

    public int getIndex(ValueType item) {
        int itemIndex = -1;
        int index = 0;
        while (index < this.getItemCount()) {
            ValueType currentItemValue = this.getItem(index);
            if (item == currentItemValue || item != null && item.equals(currentItemValue)) {
                itemIndex = index;
                break;
            }
            ++index;
        }
        return itemIndex;
    }

    public int getSelectedIndex() {
        return this.listBox.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.listBox.setSelectedIndex(index);
    }

    public ValueType getSelectedItem() {
        int index = this.listBox.getSelectedIndex();
        return index != -1 ? (ValueType)this.getItem(index) : null;
    }

    public void setSelectedItem(ValueType item) {
        this.setSelectedIndex(this.getIndex(item));
    }

    public boolean isItemSelected(int index) {
        return this.listBox.isItemSelected(index);
    }

    public void setItemSelected(int index, boolean selected) {
        this.listBox.setItemSelected(index, selected);
    }

    public int getVisibleItemCount() {
        return this.listBox.getVisibleItemCount();
    }

    public void setVisibleItemCount(int visibleItems) {
        this.listBox.setVisibleItemCount(visibleItems);
    }

    public boolean isMultipleSelect() {
        return this.listBox.isMultipleSelect();
    }

    private String getItemKey(int index) {
        return this.listBox.getValue(index);
    }

    private final class ItemKeyGenerator {
        private long itemCounter;
        private static final String ITEM_KEY_PREFIX = "option-";

        public ItemKeyGenerator() {
            this.reset();
        }

        String generate() {
            return ITEM_KEY_PREFIX + ++this.itemCounter;
        }

        void reset() {
            this.itemCounter = 0L;
        }
    }
}

