/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.WidgetConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class BusyIndicator
extends Composite {
    private final SimpleContainer popupWrapper;
    private final PopupPanel glass;
    private final PopupPanel popup;
    private ImageWidget busyImage;
    private LabelWidget busyLabel;
    private WidgetConstants constants = (WidgetConstants)GWT.create(WidgetConstants.class);
    private static final String STYLE_NAME = "nwt-BusyIndicator";
    private static final String GLASS_STYLE_NAME = "nwt-BusyIndicator-Glass";
    private static final String IMAGE_STYLE_NAME = "image";
    private static final String LABEL_STYLE_NAME = "text";
    private static final String IMAGE_URL = "neptune_widget_toolkit/images/busy-indicator.gif";

    public BusyIndicator() {
        this(true);
    }

    public BusyIndicator(boolean modal) {
        this.glass = new PopupContainer(false, true);
        this.glass.setSize("100%", "100%");
        this.glass.setStyleName(GLASS_STYLE_NAME);
        this.popupWrapper = new SimpleContainer();
        this.popup = new PopupContainer(false, modal);
        this.initialize();
        this.initWidget((Widget)this.popupWrapper);
    }

    private void initialize() {
        this.popup.setStylePrimaryName(STYLE_NAME);
        VerticalContainer contents = new VerticalContainer();
        contents.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        contents.setSpacing(3);
        this.popup.setWidget((Widget)contents);
        this.busyImage = new ImageWidget();
        this.busyImage.setStylePrimaryName(IMAGE_STYLE_NAME);
        this.busyImage.setUrl(IMAGE_URL);
        contents.add((Widget)this.busyImage);
        this.busyLabel = new LabelWidget();
        this.busyLabel.setStylePrimaryName(LABEL_STYLE_NAME);
        contents.add((Widget)this.busyLabel);
        this.busyLabel.setText(this.constants.busyIndicatorMessage());
    }

    public void setBusyMessageVisible(boolean visible) {
        this.busyLabel.setVisible(visible);
    }

    public void setBusyMessage(String message) {
        this.busyLabel.setText(message);
    }

    public void setBusyImage(String imageURL) {
        this.busyImage.setUrl(imageURL);
    }

    public void center() {
        this.showGlassPopup();
        this.popup.center();
    }

    public void show() {
        this.showGlassPopup();
        this.popup.show();
    }

    public void hide() {
        this.glass.hide();
        this.popup.hide();
    }

    public boolean isShowing() {
        return this.popup.isShowing();
    }

    public boolean isVisible() {
        return this.popup.isVisible();
    }

    public void setVisible(boolean visible) {
        this.popup.setVisible(visible);
    }

    public boolean isModal() {
        return this.popup.isModal();
    }

    public void setModal(boolean modal) {
        this.popup.setModal(modal);
    }

    public String getTitle() {
        return this.popup.getTitle();
    }

    public void setTitle(String title) {
        this.popup.setTitle(title);
    }

    public void setHeight(String height) {
        this.popup.setHeight(height);
    }

    public void setWidth(String width) {
        this.popup.setWidth(width);
    }

    public void setPopupPosition(int left, int top) {
        this.popup.setPopupPosition(left, top);
    }

    public void setPopupPositionAndShow(PopupPanel.PositionCallback callback) {
        this.showGlassPopup();
        this.popup.setPopupPositionAndShow(callback);
    }

    public void showRelativeTo(UIObject target) {
        this.showGlassPopup();
        this.popup.showRelativeTo(target);
    }

    private void showGlassPopup() {
        if (this.popup.isModal()) {
            this.glass.show();
        }
    }
}

