/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class FormContainer
extends Composite
implements INeptuneWidget {
    private static final String STYLE_CONTAINER_TABLE = "form-container-table";
    private static final String STYLE_LABEL_CELL = "form-label-cell";
    private static final String STYLE_VALUE_CELL = "form-value-cell";
    private static final String STYLE_REQUIRED = "form-required";
    private static final String STYLE_LABEL = "form-label";
    private static final String STYLE_VALUE = "form-value";
    private static final int MAINPANEL_SPACING = 10;
    private VerticalPanel mainPanel = new VerticalPanel();
    private FlexTable formTable;
    private HorizontalPanel buttonPanel;

    public FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant buttonPanelHAlign) {
        this.mainPanel.setSpacing(10);
        this.formTable = new FlexTable();
        this.formTable.setStyleName(STYLE_CONTAINER_TABLE);
        this.buttonPanel = new HorizontalPanel();
        this.mainPanel.add((Widget)this.formTable);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.formTable, VerticalPanel.ALIGN_CENTER);
        this.mainPanel.add((Widget)this.buttonPanel);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.buttonPanel, buttonPanelHAlign);
        this.initWidget((Widget)this.mainPanel);
    }

    public int addRow(LabelWidget label, Widget value, boolean markRequired) {
        label.setStyleName(STYLE_LABEL);
        value.setStyleName(STYLE_VALUE);
        int lastRowIndex = this.formTable.getRowCount();
        if (markRequired) {
            HorizontalContainer container = new HorizontalContainer();
            container.setStyleName(STYLE_LABEL);
            LabelWidget requiredMarker = new LabelWidget("*");
            requiredMarker.setStyleName(STYLE_REQUIRED);
            container.add((Widget)requiredMarker);
            container.setCellWidth((Widget)requiredMarker, "10");
            container.add((Widget)label);
            this.formTable.setWidget(lastRowIndex, 0, (Widget)container);
        } else {
            this.formTable.setWidget(lastRowIndex, 0, (Widget)label);
        }
        this.formTable.getCellFormatter().setStyleName(lastRowIndex, 0, STYLE_LABEL_CELL);
        this.formTable.setWidget(lastRowIndex, 1, value);
        this.formTable.getCellFormatter().setStyleName(lastRowIndex, 1, STYLE_VALUE_CELL);
        return lastRowIndex;
    }

    public int addRow(LabelWidget label, Widget value) {
        return this.addRow(label, value, false);
    }

    public int addRow(String first, Widget second, boolean markRequired) {
        return this.addRow(new LabelWidget(first), second, markRequired);
    }

    public int addRow(String first, Widget second) {
        return this.addRow(first, second, false);
    }

    public void removeRow(int index) {
        this.formTable.removeRow(index);
    }

    public void addButton(ButtonWidget buttonWidget) {
        this.buttonPanel.add((Widget)buttonWidget);
    }

    public void removeButton(ButtonWidget buttonWidget) {
        this.buttonPanel.remove((Widget)buttonWidget);
    }
}

