/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.i18n.NeptuneWidgetConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.MenuBarWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.InvalidPagePanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class TreeTabPanel
extends Composite
implements INeptuneWidget {
    private final VerticalContainer mainContainer;
    private final MenuBarWidget tabMenuBar;
    private final SimpleContainer centerContainer;
    private final MenuNode rootNode;
    private WidgetFactory currentFactory;
    private final List<Listener> listeners;
    private final AnchorChangeListener frameworkListener;
    private NeptuneWidgetConstants constants = (NeptuneWidgetConstants)GWT.create(NeptuneWidgetConstants.class);

    public TreeTabPanel(AnchorChangeListener frameworkListener, String username) {
        this.frameworkListener = frameworkListener;
        this.listeners = new ArrayList<Listener>();
        this.rootNode = new MenuNode("", "");
        this.tabMenuBar = new MenuBarWidget();
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setWidth("100%");
        this.tabMenuBar.addItem(this.constants.loading(), new Command(){

            public void execute() {
            }
        });
        HorizontalContainer menuContainer = new HorizontalContainer();
        menuContainer.setWidth("100%");
        LabelWidget loggedInAs = new LabelWidget(String.valueOf(this.constants.loggedInAs()) + username);
        loggedInAs.setStyleName("loggedIn");
        menuContainer.add((Widget)this.tabMenuBar);
        menuContainer.setCellHorizontalAlignment((Widget)this.tabMenuBar, HorizontalContainer.ALIGN_LEFT);
        menuContainer.add((Widget)loggedInAs);
        menuContainer.setCellHorizontalAlignment((Widget)loggedInAs, HorizontalContainer.ALIGN_RIGHT);
        this.mainContainer.add((Widget)menuContainer);
        this.centerContainer = new SimpleContainer();
        this.centerContainer.setStyleName("neptune-center-container");
        this.centerContainer.setSize("100%", "100%");
        this.mainContainer.add((Widget)this.centerContainer);
        this.mainContainer.setCellHorizontalAlignment((Widget)this.centerContainer, HorizontalContainer.ALIGN_CENTER);
        this.initWidget((Widget)this.mainContainer);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public MenuNode getRootMenu() {
        return this.rootNode;
    }

    public void doLayout() {
        this.tabMenuBar.clearItems();
        for (Node node : this.rootNode.subNodes) {
            this.tabMenuBar.addItem(node.createMenuItem());
        }
    }

    public void setActiveTab(String token) {
        String[] tokenBits;
        int indexOfParams = token.indexOf(63);
        String params = null;
        if (indexOfParams != -1) {
            params = token.substring(indexOfParams);
            token = token.substring(0, indexOfParams);
        }
        LinkedList<String> queue = new LinkedList<String>();
        String[] stringArray = tokenBits = token.split("\\.", -1);
        int n = tokenBits.length;
        int n2 = 0;
        while (n2 < n) {
            String tokenBit = stringArray[n2];
            queue.add(tokenBit);
            ++n2;
        }
        NodeActivator locator = new NodeActivator(queue, params);
        this.rootNode.accept(locator);
    }

    public final class ActionNode
    extends Node {
        private final Runnable runnable;

        public ActionNode(String name, String displayName, Runnable runnable) {
            super(name, displayName);
            this.runnable = runnable;
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected MenuItem createMenuItem() {
            return new MenuItem(this.displayName, new Command(){

                public void execute() {
                    ActionNode.this.runnable.run();
                }
            });
        }
    }

    public static interface AnchorChangeListener {
        public void anchorChanged(String var1);
    }

    public static interface Listener {
        public void tabChanged(TabNode var1);
    }

    public final class MenuNode
    extends Node {
        private final List<Node> subNodes;
        private final Map<String, Node> nameToSubNode;

        private MenuNode(String name, String displayName) {
            super(name, displayName);
            this.subNodes = new ArrayList<Node>();
            this.nameToSubNode = new HashMap<String, Node>();
        }

        public MenuNode getMenuNode(String name) {
            for (Node node : this.subNodes) {
                if (!(node instanceof MenuNode) || !node.name.equals(name)) continue;
                return (MenuNode)node;
            }
            return null;
        }

        @Override
        protected MenuItem createMenuItem() {
            MenuBar subMenu = new MenuBar(true);
            for (Node node : this.subNodes) {
                subMenu.addItem(node.createMenuItem());
            }
            return new MenuItem(this.displayName, subMenu);
        }

        public MenuNode addMenuNode(String name, String displayName) {
            MenuNode subMenuNode = new MenuNode(name, displayName);
            this.addNode(subMenuNode);
            return subMenuNode;
        }

        public TabNode addTabNode(String name, String displayName, WidgetFactory widgetFactory, AnchorChangeListener tabListener) {
            TabNode panelTabNode = new TabNode(name, displayName, widgetFactory, tabListener);
            this.addNode(panelTabNode);
            return panelTabNode;
        }

        public TabNode addTabNode(String name, WidgetFactory widgetFactory) {
            return this.addTabNode(name, name, widgetFactory, null);
        }

        public ActionNode addActionNode(String name, String displayName, Runnable runnable) {
            ActionNode actionNode = new ActionNode(name, displayName, runnable);
            this.addNode(actionNode);
            return actionNode;
        }

        private void addNode(Node node) {
            this.subNodes.add(node);
            node.parentNode = this;
            this.nameToSubNode.put(node.name, node);
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public abstract class Node {
        protected final String name;
        protected final String displayName;
        protected MenuNode parentNode;

        protected Node(String name) {
            this.name = name;
            this.displayName = name;
        }

        protected Node(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        protected abstract MenuItem createMenuItem();

        public abstract void accept(NodeVisitor var1);

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private final class NodeActivator
    implements NodeVisitor {
        private final Queue<String> queue;
        private final String params;

        public NodeActivator(Queue<String> queue, String params) {
            this.queue = queue;
            this.params = params;
        }

        @Override
        public void visit(MenuNode menuNode) {
            if (this.queue.peek() == null) {
                return;
            }
            String name = this.queue.remove();
            Node node = (Node)menuNode.nameToSubNode.get(name);
            if (node != null) {
                NodeActivator subLocator = new NodeActivator(this.queue, this.params);
                node.accept(subLocator);
            } else {
                TreeTabPanel.this.centerContainer.clear();
                TreeTabPanel.this.centerContainer.add((Widget)new InvalidPagePanel(TreeTabPanel.this.constants.invalidURL()));
            }
        }

        @Override
        public void visit(TabNode panelTabNode) {
            panelTabNode.activatePanel(this.queue, this.params, false);
        }

        @Override
        public void visit(ActionNode node) {
        }
    }

    public static interface NodeVisitor {
        public void visit(MenuNode var1);

        public void visit(TabNode var1);

        public void visit(ActionNode var1);
    }

    public final class TabNode
    extends Node {
        private final WidgetFactory widgetFactory;
        private final AnchorChangeListener tabAnchorListener;
        private final AnchorChangeListener reverseAnchorListener;

        private TabNode(String name, String displayName, WidgetFactory widgetFactory, AnchorChangeListener tabListener) {
            super(name, displayName);
            this.widgetFactory = widgetFactory;
            this.tabAnchorListener = tabListener;
            this.reverseAnchorListener = new AnchorChangeListener(){

                @Override
                public void anchorChanged(String anchor) {
                    StringBuilder realAnchor = new StringBuilder();
                    realAnchor.append(TabNode.this.getToken());
                    if (!anchor.startsWith("?")) {
                        realAnchor.append('.');
                    }
                    realAnchor.append(anchor);
                    TreeTabPanel.this.frameworkListener.anchorChanged(realAnchor.toString());
                }
            };
        }

        private TabNode(String name, WidgetFactory widgetFactory) {
            this(name, name, widgetFactory, null);
        }

        public String getToken() {
            StringBuilder token = new StringBuilder();
            this.constructToken(this, token);
            return token.toString();
        }

        public AnchorChangeListener getReverseAnchorChangeListener() {
            return this.reverseAnchorListener;
        }

        public String getName() {
            return this.name;
        }

        public WidgetFactory getWidgetFactory() {
            return this.widgetFactory;
        }

        private void constructToken(Node node, StringBuilder builder) {
            if (node == null) {
                return;
            }
            this.constructToken(node.parentNode, builder);
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(node.name);
        }

        @Override
        protected MenuItem createMenuItem() {
            return new MenuItem(this.displayName, new Command(){

                public void execute() {
                    TabNode.this.activatePanel(true);
                }
            });
        }

        public void activatePanel(Queue<String> queue, String params, boolean notifyListener) {
            StringBuilder anchor = new StringBuilder();
            for (String bit : queue) {
                anchor.append(bit).append('.');
            }
            if (anchor.length() > 0) {
                anchor.setLength(anchor.length() - 1);
            }
            if (params != null) {
                anchor.append(params);
            }
            if (TreeTabPanel.this.currentFactory != null && TreeTabPanel.this.centerContainer.getWidget() != null) {
                TreeTabPanel.this.currentFactory.release(TreeTabPanel.this.centerContainer.getWidget());
            }
            TreeTabPanel.this.currentFactory = this.widgetFactory;
            TreeTabPanel.this.centerContainer.clear();
            TreeTabPanel.this.centerContainer.add((Widget)this.widgetFactory.getInstance());
            if (this.tabAnchorListener != null) {
                this.tabAnchorListener.anchorChanged(anchor.toString());
            }
            if (notifyListener) {
                for (Listener listener : TreeTabPanel.this.listeners) {
                    listener.tabChanged(this);
                }
            }
        }

        public void activatePanel(boolean notifyListener) {
            this.activatePanel(new LinkedList<String>(), null, notifyListener);
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

