/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.InternalTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableListViewPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.BookmarkFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.DetailFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.FeatureEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.FeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.PageFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.SortFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Table<K, R extends Record<K>>
extends Composite
implements INeptuneWidget {
    private final SimplePanel mainPanel;
    private final TableListViewPanel<K, R> listViewPanel;
    private final DataProvider<K, R> dataProvider;
    private final InternalTable<K, R> internalTable;
    private String viewName = null;
    private String listViewName = "";
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private final List<TableAnchorChangeHandler> anchorChangeHandlers = new ArrayList<TableAnchorChangeHandler>();
    private SortFeatureHandler<K, R> sortFeatureHandler;
    private PageFeatureHandler<K, R> pageFeatureHandler;
    private DetailFeatureHandler<K, R> detailFeatureHandler;
    private BookmarkFeatureHandler<K, R> bookmarkFeatureHandler;
    private final List<FeatureHandler<?>> featureHandlers;
    private boolean initialized = false;
    private boolean initializationStarted = false;
    private boolean providerInitializing = false;
    private List<AsyncCallback<Void>> initializationCallbacks = new ArrayList<AsyncCallback<Void>>();
    private static final String DEFAULT_LIST_VIEW_NAME = "";

    public Table(DataProvider<K, R> dataProvider) {
        this.dataProvider = dataProvider;
        this.internalTable = new InternalTable(this);
        this.featureHandlers = new ArrayList();
        this.mainPanel = new SimpleContainer();
        this.listViewPanel = new TableListViewPanel<K, R>(dataProvider);
        this.listViewPanel.addListener(new TableListViewPanel.Listener(){

            @Override
            public void updated() {
                Table.this.handleListViewUpdated();
            }
        });
        this.mainPanel.setWidget((Widget)new LabelWidget(DEFAULT_LIST_VIEW_NAME));
        this.initWidget((Widget)this.mainPanel);
    }

    public synchronized void initialize(AsyncCallback<Void> callback) {
        if (this.initialized) {
            if (callback != null) {
                callback.onSuccess(null);
            }
            return;
        }
        this.initializationStarted = true;
        if (callback != null) {
            this.initializationCallbacks.add(callback);
        }
        if (!this.providerInitializing) {
            this.providerInitializing = true;
            this.dataProvider.initialize(new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    Table.this.handleProviderInitializationFailure(caught);
                }

                public void onSuccess(Void result) {
                    Table.this.handleProviderInitializationSuccess(result);
                }
            });
        }
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void validateNotInitialized(String operation) {
        if (this.initializationStarted) {
            String msg = "The table initialization has already started, cannot perform operation: " + operation + " after initialization.";
            throw new RuntimeException(msg);
        }
    }

    private synchronized void handleProviderInitializationFailure(Throwable error) {
        this.providerInitializing = false;
        for (AsyncCallback<Void> callback : this.initializationCallbacks) {
            try {
                callback.onFailure(error);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initializationCallbacks.clear();
    }

    private synchronized void handleProviderInitializationSuccess(Void result) {
        this.providerInitializing = false;
        for (FeatureHandler<?> featureHandler : this.featureHandlers) {
            featureHandler.initialize();
        }
        this.initialized = true;
        this.showListView();
        for (AsyncCallback asyncCallback : this.initializationCallbacks) {
            try {
                asyncCallback.onSuccess((Object)result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initializationCallbacks.clear();
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getListViewName() {
        return this.listViewName;
    }

    public void setListViewName(String listViewName) {
        this.validateNotInitialized("setListViewName");
        if (listViewName == null) {
            throw new IllegalArgumentException("The list view name cannot be null.");
        }
        this.listViewName = listViewName;
    }

    void showView(Widget view, String viewName) {
        if (!this.isInitialized()) {
            String msg = "Cannot set the table view before the table is initialized.";
            throw new RuntimeException(msg);
        }
        this.mainPanel.setWidget(view);
        this.viewName = viewName;
    }

    boolean isShowingView(Widget view) {
        return this.mainPanel.getWidget() == view;
    }

    public void showListView() {
        this.showView((Widget)this.listViewPanel, this.listViewName);
    }

    public boolean isShowingListView() {
        return this.isShowingView((Widget)this.listViewPanel);
    }

    public TableAnchor getTableAnchor() {
        TableAnchor anchor = new TableAnchor();
        anchor.setViewName(this.viewName);
        for (FeatureHandler<?> handler : this.featureHandlers) {
            Map<String, String> featureTokens = handler.getAnchorTokens();
            if (featureTokens == null) continue;
            anchor.getTokens().putAll(featureTokens);
        }
        return anchor;
    }

    public void setTableAnchor(TableAnchor anchor) {
        this.reset();
        this.showListView();
        for (FeatureHandler<?> featureHandler : this.featureHandlers) {
            featureHandler.setAnchor(anchor);
        }
        if (this.isShowingListView()) {
            this.refresh();
        }
    }

    public void addAnchorChangeHandler(TableAnchorChangeHandler handler) {
        if (handler != null && !this.anchorChangeHandlers.contains(handler)) {
            this.anchorChangeHandlers.add(handler);
        }
    }

    public void removeAnchorChangeHandler(TableAnchorChangeHandler handler) {
        this.anchorChangeHandlers.remove(handler);
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeNotifier() {
        return this.anchorChangeNotifier;
    }

    public void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeNotifier) {
        this.anchorChangeNotifier = anchorChangeNotifier;
    }

    public void addPageFeature(PageFeature pageFeature) {
        this.validateNotInitialized("addPageFeature");
        if (this.hasPageFeature()) {
            String msg = "The Page Feature is already installed, cannot add this feature again.";
            throw new RuntimeException(msg);
        }
        this.pageFeatureHandler = new PageFeatureHandler<K, R>(this.internalTable, pageFeature);
        this.featureHandlers.add(this.pageFeatureHandler);
    }

    public boolean hasPageFeature() {
        return this.pageFeatureHandler != null;
    }

    public PageFeature getPageFeature() {
        return this.hasPageFeature() ? (PageFeature)this.pageFeatureHandler.getFeature() : null;
    }

    public void addSortFeature(SortFeature<K, R> sortFeature) {
        this.validateNotInitialized("addSortFeature");
        if (this.hasSortFeature()) {
            String msg = "The Sort Feature is already installed, cannot add this feature again.";
            throw new RuntimeException(msg);
        }
        this.sortFeatureHandler = new SortFeatureHandler<K, R>(this.internalTable, sortFeature);
        this.featureHandlers.add(this.sortFeatureHandler);
    }

    public boolean hasSortFeature() {
        return this.sortFeatureHandler != null;
    }

    public SortFeature<K, R> getSortFeature() {
        return this.hasSortFeature() ? (SortFeature)this.sortFeatureHandler.getFeature() : null;
    }

    public void addDetailFeature(DetailFeature<K, R> detailFeature) {
        this.validateNotInitialized("addDetailFeature");
        if (this.hasDetailFeature()) {
            String msg = "The Detail Feature is already installed, cannot add this feature again.";
            throw new RuntimeException(msg);
        }
        this.detailFeatureHandler = new DetailFeatureHandler<K, R>(this.internalTable, detailFeature);
        this.featureHandlers.add(this.detailFeatureHandler);
    }

    public boolean hasDetailFeature() {
        return this.detailFeatureHandler != null;
    }

    public DetailFeature<K, R> getDetailFeature() {
        return this.hasDetailFeature() ? (DetailFeature)this.detailFeatureHandler.getFeature() : null;
    }

    public void showCreateView() {
        this.detailFeatureHandler.showCreateView();
    }

    public void showDetailView(R record) {
        this.detailFeatureHandler.showDetailView(record);
    }

    public void addBookmarkFeature(BookmarkFeature feature) {
        this.validateNotInitialized("addBookmarkFeature");
        if (this.hasBookmarkFeature()) {
            String msg = "The Bookmark Feature is already installed, cannot add this feature again.";
            throw new RuntimeException(msg);
        }
        this.bookmarkFeatureHandler = new BookmarkFeatureHandler<K, R>(this.internalTable, feature);
        this.featureHandlers.add(this.bookmarkFeatureHandler);
    }

    public boolean hasBookmarkFeature() {
        return this.bookmarkFeatureHandler != null;
    }

    public BookmarkFeature getBookmarkFeature() {
        return this.hasBookmarkFeature() ? (BookmarkFeature)this.bookmarkFeatureHandler.getFeature() : null;
    }

    public void setAnchor(String anchor) {
        this.bookmarkFeatureHandler.handleBrowserAnchorChange(anchor);
    }

    public void updateAnchor() {
        this.fireAnchorChangeEvent();
    }

    public void refresh() {
        if (!this.isInitialized()) {
            throw new RuntimeException("Cannot refresh the table until initialization completes.");
        }
        this.listViewPanel.refresh();
    }

    public void reset() {
        if (!this.isInitialized()) {
            String msg = "The table must be initialized before being reset.";
            throw new RuntimeException(msg);
        }
        this.listViewPanel.clearRecords();
        this.showView((Widget)new LabelWidget(DEFAULT_LIST_VIEW_NAME), this.listViewName);
        for (FeatureHandler<?> handler : this.featureHandlers) {
            handler.reset();
        }
    }

    public boolean isDisplayed() {
        if (!this.isAttached()) {
            return false;
        }
        Table current = this;
        while (current != null && current.isVisible()) {
            current = current.getParent();
        }
        return current == null;
    }

    public List<R> getRecords() {
        return this.listViewPanel.getRecords();
    }

    public List<R> getSelectedRecords() {
        return this.listViewPanel.getSelectedRecords();
    }

    public int getDataRowCount() {
        return this.listViewPanel.getDataRowCount();
    }

    public void registerWidgetOnActionContainer(Widget widget) {
        this.listViewPanel.getActionContainer().add(widget);
    }

    List<Column<?, R>> getColumns() {
        return this.listViewPanel.listVisibleColumns();
    }

    List<Widget> getWidgetsForColumn(Column<?, R> column) {
        return this.listViewPanel.listWidgetsForVisibleColumn(column);
    }

    R getRecordForWidget(Widget widget) {
        return this.listViewPanel.getRecordForWidget(widget);
    }

    void getRecordForKey(K key, AsyncCallback<R> callback) {
        this.dataProvider.getRecord(key, callback);
    }

    HorizontalPanel getHeaderWidgetForColumn(Column<?, R> column) {
        return this.listViewPanel.getHeaderColPanelForColumn(column);
    }

    Label getHeaderWidgetLabelForColumn(Column<?, R> column) {
        return this.listViewPanel.getHeaderLabelForColumn(column);
    }

    SimpleContainer getPaginationPanel() {
        return this.listViewPanel.getPaginationPanel();
    }

    void handleFeatureEvent(FeatureEvent featureEvent) {
        if (this.isShowingListView()) {
            this.refresh();
        }
        if (featureEvent.isAnchorChangeRequired()) {
            this.fireAnchorChangeEvent();
        }
    }

    private void handleListViewUpdated() {
        if (this.hasPageFeature()) {
            int recordCount = this.getPageFeature().getRecordCount();
            int pageSize = this.getPageFeature().getPageSize();
            int dataRows = this.getDataRowCount();
            if (dataRows == 0 && recordCount > 0) {
                int lastPage = recordCount / pageSize;
                if (recordCount % pageSize > 0) {
                    ++lastPage;
                }
                this.getPageFeature().setPageNumber(lastPage);
                this.refresh();
                return;
            }
        }
        for (FeatureHandler<?> handler : this.featureHandlers) {
            handler.refresh();
        }
    }

    private void fireAnchorChangeEvent() {
        TableAnchor anchor = this.getTableAnchor();
        TableAnchorChangeEvent event = new TableAnchorChangeEvent(anchor);
        for (TableAnchorChangeHandler handler : this.anchorChangeHandlers) {
            handler.onAnchorChange(event);
        }
    }
}

