/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.CheckBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TableColumnPanel<K, R extends Record<K>>
extends FlexTable {
    private final DataProvider<K, R> dataProvider;
    private int colIndex;
    private List<R> records;
    private CheckBox<R> headerRowCheckbox;
    private List<CheckBox<R>> dataRowsCheckBoxes;
    private List<Column<?, R>> visibleColumns;
    private Map<Column<?, R>, List<Widget>> visibleColumnToWidgetListMap;
    private Map<Widget, R> widgetToRecordMap;
    private Map<Column<?, R>, Label> visibleColumnToHeaderLabel;
    private Map<Column<?, R>, HorizontalPanel> visibleColumnToHeaderColPanel;

    public TableColumnPanel(DataProvider<K, R> dataProvider) {
        this.dataProvider = dataProvider;
        this.initializeWidget();
    }

    private void initializeWidget() {
        this.records = new ArrayList<R>();
        this.headerRowCheckbox = new CheckBox();
        this.dataRowsCheckBoxes = new ArrayList<CheckBox<R>>();
        this.visibleColumns = new ArrayList();
        this.visibleColumnToWidgetListMap = new HashMap();
        this.widgetToRecordMap = new HashMap<Widget, R>();
        this.visibleColumnToHeaderColPanel = new HashMap();
        this.visibleColumnToHeaderLabel = new HashMap();
        this.setSize("100%", "100%");
        this.getRowFormatter().setStyleName(0, "table-header-row");
        this.colIndex = 0;
        if (this.dataProvider.isCheckboxEnabled()) {
            this.headerRowCheckbox.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TableColumnPanel.this.handleHeaderCheckBoxClick(event);
                }
            });
            this.setWidget(0, this.colIndex++, (Widget)this.headerRowCheckbox);
        }
        for (Column<?, R> column : this.dataProvider.getColumns()) {
            this.addColumn(column);
        }
    }

    private void addColumn(Column<?, R> column) {
        this.visibleColumns.add(column);
        HorizontalPanel headerColPanel = new HorizontalPanel();
        headerColPanel.setSpacing(3);
        headerColPanel.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
        Label headerLabel = new Label(column.getDisplayName());
        headerColPanel.add((Widget)headerLabel);
        headerLabel.setStyleName("table-header-nonSortable-text");
        this.setWidget(0, this.colIndex++, (Widget)headerColPanel);
        this.visibleColumnToHeaderLabel.put(column, headerLabel);
        this.visibleColumnToHeaderColPanel.put(column, headerColPanel);
    }

    public void clearRecords() {
        this.records.clear();
        this.headerRowCheckbox.setValue(false);
        this.visibleColumnToWidgetListMap.clear();
        this.widgetToRecordMap.clear();
        this.dataRowsCheckBoxes.clear();
        int rowCount = this.getRowCount();
        int i = rowCount - 1;
        while (i > 0) {
            this.removeRow(i);
            --i;
        }
    }

    public void updateRecords(List<R> result) {
        this.clearRecords();
        if (result != null) {
            this.records.addAll(result);
        }
        int rowIndex = 1;
        for (Record record : this.records) {
            String styleName = rowIndex % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
            this.getRowFormatter().setStyleName(rowIndex, styleName);
            int colIndex = 0;
            if (this.dataProvider.isCheckboxEnabled()) {
                final CheckBox checkBox = new CheckBox();
                checkBox.setRecord(record);
                checkBox.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        TableColumnPanel.this.handleDataCheckBoxClick(checkBox, event);
                    }
                });
                this.dataRowsCheckBoxes.add(checkBox);
                this.setWidget(rowIndex, colIndex++, (Widget)checkBox);
            }
            for (Column<?, Record> column : this.visibleColumns) {
                View<?> listView = column.getView(record);
                String viewStyleName = listView.getStyleName();
                if (viewStyleName == null) {
                    viewStyleName = "table-data-text";
                }
                Widget widget = listView.getWidget();
                widget.setStyleName(viewStyleName);
                this.setWidget(rowIndex, colIndex, widget);
                ++colIndex;
                this.getInitializedWidgetList(column).add(widget);
                this.widgetToRecordMap.put(widget, record);
            }
            ++rowIndex;
        }
    }

    private List<Widget> getInitializedWidgetList(Column<?, R> visibleColumn) {
        List<Widget> list = this.visibleColumnToWidgetListMap.get(visibleColumn);
        if (list == null) {
            list = new ArrayList<Widget>();
            this.visibleColumnToWidgetListMap.put(visibleColumn, list);
        }
        return list;
    }

    public List<Column<?, R>> listVisibleColumns() {
        return this.visibleColumns;
    }

    public List<Widget> listWidgetsForVisibleColumn(Column<?, R> column) {
        return this.visibleColumnToWidgetListMap.get(column);
    }

    public R getRecordForWidget(Widget widget) {
        return (R)((Record)this.widgetToRecordMap.get(widget));
    }

    public List<R> getRecords() {
        ArrayList<R> visibleRecords = new ArrayList<R>();
        visibleRecords.addAll(this.records);
        return visibleRecords;
    }

    public List<R> listSelectedRecords() {
        ArrayList<R> records = new ArrayList<R>();
        for (CheckBox<R> checkBox : this.dataRowsCheckBoxes) {
            if (!checkBox.getValue().booleanValue()) continue;
            records.add(checkBox.getRecord());
        }
        return records;
    }

    public int getDataRowCount() {
        return this.records.size();
    }

    private void handleHeaderCheckBoxClick(ClickEvent event) {
        Boolean headerValue = this.headerRowCheckbox.getValue();
        for (CheckBox<R> dataRowCB : this.dataRowsCheckBoxes) {
            dataRowCB.setValue(headerValue);
        }
    }

    private void handleDataCheckBoxClick(CheckBox<R> source, ClickEvent event) {
        if (this.headerRowCheckbox.getValue().booleanValue() && !source.getValue().booleanValue()) {
            this.headerRowCheckbox.setValue(false);
        }
    }

    public HorizontalPanel getHeaderColumnPanel(Column<?, R> column) {
        return this.visibleColumnToHeaderColPanel.get(column);
    }

    public Label getHeaderColumnLabel(Column<?, R> column) {
        return this.visibleColumnToHeaderLabel.get(column);
    }

    public CheckBox<R> getHeaderRowCheckBox() {
        return this.headerRowCheckbox;
    }
}

