/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableColumnPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedCornerContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

class TableListViewPanel<K, R extends Record<K>>
extends RoundedCornerContainer {
    private final DataProvider<K, R> dataProvider;
    private SimpleContainer paginationPanel;
    private HorizontalContainer actionContainer;
    private TableColumnPanel<K, R> columnPanel;
    private List<Listener> listeners;
    private VerticalContainer mainContainer;

    public TableListViewPanel(DataProvider<K, R> dataProvider) {
        super(15, 9);
        this.dataProvider = dataProvider;
        this.initializeWidget();
    }

    private void initializeWidget() {
        this.listeners = new ArrayList<Listener>();
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStyleName("table-panel");
        this.actionContainer = new HorizontalContainer();
        this.paginationPanel = new SimpleContainer();
        this.columnPanel = new TableColumnPanel<K, R>(this.dataProvider);
        this.mainContainer.setSpacing(3);
        this.mainContainer.setSize("100%", "100%");
        this.mainContainer.setHorizontalAlignment(VerticalContainer.ALIGN_CENTER);
        this.columnPanel.setStyleName("table-body");
        this.mainContainer.setCellHorizontalAlignment((Widget)this.columnPanel, VerticalContainer.ALIGN_LEFT);
        this.mainContainer.add((Widget)this.columnPanel);
        if (this.dataProvider.isRecordCountEnabled()) {
            SimpleContainer numRecordsPanel = new SimpleContainer();
            LabelWidget numRecordsLabel = new LabelWidget("");
            numRecordsLabel.setStyleName("table-general-text");
            numRecordsPanel.setWidget((Widget)numRecordsLabel);
            this.mainContainer.add((Widget)numRecordsPanel);
        }
        this.mainContainer.add((Widget)this.actionContainer);
        this.mainContainer.setCellHorizontalAlignment((Widget)this.actionContainer, VerticalContainer.ALIGN_LEFT);
        this.paginationPanel.setWidth("100%");
        this.mainContainer.add((Widget)this.paginationPanel);
        this.mainContainer.setCellHorizontalAlignment((Widget)this.paginationPanel, VerticalContainer.ALIGN_CENTER);
        this.setWidget((Widget)this.mainContainer);
        this.setSize("100%", "100%");
        this.setCornerStyleName("table-panel");
    }

    public HorizontalPanel getHeaderColPanelForColumn(Column<?, R> column) {
        return this.columnPanel.getHeaderColumnPanel(column);
    }

    public Label getHeaderLabelForColumn(Column<?, R> column) {
        return this.columnPanel.getHeaderColumnLabel(column);
    }

    public void refresh() {
        this.dataProvider.getRecords(new AsyncCallback<List<R>>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
                TableListViewPanel.this.columnPanel.updateRecords(new ArrayList());
                TableListViewPanel.this.notifyAllListeners();
            }

            public void onSuccess(List<R> result) {
                TableListViewPanel.this.columnPanel.updateRecords(result);
                TableListViewPanel.this.notifyAllListeners();
            }
        });
    }

    public void clearRecords() {
        this.columnPanel.clearRecords();
    }

    public SimpleContainer getPaginationPanel() {
        return this.paginationPanel;
    }

    public List<Column<?, R>> listVisibleColumns() {
        return this.columnPanel.listVisibleColumns();
    }

    public List<Widget> listWidgetsForVisibleColumn(Column<?, R> visibleColumn) {
        return this.columnPanel.listWidgetsForVisibleColumn(visibleColumn);
    }

    public R getRecordForWidget(Widget widget) {
        return this.columnPanel.getRecordForWidget(widget);
    }

    public HorizontalContainer getActionContainer() {
        return this.actionContainer;
    }

    public List<R> getRecords() {
        return this.columnPanel.listSelectedRecords();
    }

    public List<R> getSelectedRecords() {
        return this.columnPanel.listSelectedRecords();
    }

    public int getDataRowCount() {
        return this.columnPanel.getDataRowCount();
    }

    public void addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAllListeners() {
        for (Listener listener : this.listeners) {
            listener.updated();
        }
    }

    public static interface Listener {
        public void updated();
    }
}

