/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import java.util.HashMap;
import java.util.Map;

public class AnchorTokenizer {
    public static final String ANCHOR_SEPARATOR = "&";
    public static final String TOKEN_SEPARATOR = "=";
    public static final String ESCAPED_ANCHOR_SEPARATOR = "&amp;";
    public static final String ESCAPED_TOKEN_SEPARATOR = "&eq;";

    public String buildAnchor(Map<String, String> anchorTokens) {
        if (anchorTokens == null) {
            return "";
        }
        StringBuilder anchor = new StringBuilder();
        boolean first = true;
        for (String key : anchorTokens.keySet()) {
            String value = anchorTokens.get(key);
            if (key == null || value == null) continue;
            if (first) {
                first = false;
            } else {
                anchor.append(ANCHOR_SEPARATOR);
            }
            anchor.append(this.escapeValue(key));
            anchor.append(TOKEN_SEPARATOR);
            anchor.append(this.escapeValue(value));
        }
        return anchor.toString();
    }

    public Map<String, String> parseAnchor(String anchor) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        if (anchor == null) {
            return tokens;
        }
        int startIndex = 0;
        int index = 0;
        while (index < anchor.length()) {
            String[] tokenParts;
            String token = null;
            if (this.isMatch(anchor, index, ANCHOR_SEPARATOR) && !this.isEscapeSequence(anchor, index)) {
                token = anchor.substring(startIndex, index);
                startIndex = index + ANCHOR_SEPARATOR.length();
                index += ANCHOR_SEPARATOR.length();
            } else if (index == anchor.length() - 1) {
                token = anchor.substring(startIndex);
                startIndex = index + 1;
                ++index;
            } else {
                ++index;
            }
            if (token == null || (tokenParts = token.split(TOKEN_SEPARATOR, 2)).length != 2) continue;
            String key = this.unescapeValue(tokenParts[0]);
            String value = this.unescapeValue(tokenParts[1]);
            if (key == null || value == null) continue;
            tokens.put(key, value);
        }
        return tokens;
    }

    private String escapeValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < value.length()) {
            if (this.isMatch(value, index, ANCHOR_SEPARATOR)) {
                result.append(ESCAPED_ANCHOR_SEPARATOR);
                index += ANCHOR_SEPARATOR.length();
                continue;
            }
            if (this.isMatch(value, index, TOKEN_SEPARATOR)) {
                result.append(ESCAPED_TOKEN_SEPARATOR);
                index += TOKEN_SEPARATOR.length();
                continue;
            }
            result.append(value.charAt(index));
            ++index;
        }
        return result.toString();
    }

    private String unescapeValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < value.length()) {
            if (this.isMatch(value, index, ESCAPED_ANCHOR_SEPARATOR)) {
                result.append(ANCHOR_SEPARATOR);
                index += ESCAPED_ANCHOR_SEPARATOR.length();
                continue;
            }
            if (this.isMatch(value, index, ESCAPED_TOKEN_SEPARATOR)) {
                result.append(TOKEN_SEPARATOR);
                index += ESCAPED_TOKEN_SEPARATOR.length();
                continue;
            }
            result.append(value.charAt(index));
            ++index;
        }
        return result.toString();
    }

    private boolean isEscapeSequence(String value, int startIndex) {
        return this.isMatch(value, startIndex, ESCAPED_ANCHOR_SEPARATOR) || this.isMatch(value, startIndex, ESCAPED_TOKEN_SEPARATOR);
    }

    private boolean isMatch(String value, int startIndex, String match) {
        int endIndex;
        int length = value.length();
        return length >= (endIndex = startIndex + match.length()) && value.substring(startIndex, endIndex).equals(match);
    }
}

