/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import java.util.HashSet;
import java.util.Set;

public final class SortFeatureImpl<K, R extends Record<K>>
implements SortFeature<K, R> {
    private final Column<?, R> defaultSortColumn;
    private final SortOrder defaultSortOrder;
    private Column<?, R> sortColumn;
    private SortOrder sortOrder;
    private final Set<Column<?, R>> sortableColumns;

    public SortFeatureImpl(Column<?, R> defaultSortColumn, SortOrder defaultSortOrder) {
        this.defaultSortColumn = defaultSortColumn;
        this.defaultSortOrder = defaultSortOrder;
        this.sortableColumns = new HashSet();
        this.reset();
    }

    @Override
    public boolean isColumnSortable(Column<?, R> column) {
        return this.sortableColumns.contains(column);
    }

    @Override
    public Set<Column<?, R>> getSortableColumns() {
        return this.sortableColumns;
    }

    public void addSortableColumn(Column<?, R> column) {
        this.sortableColumns.add(column);
    }

    @Override
    public SortOrder getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    @Override
    public Column<?, R> getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public Column<?, R> getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(Column<?, R> column) {
        this.sortColumn = column;
    }

    public boolean isAscending() {
        return SortOrder.ASCENDING.equals((Object)this.getSortOrder());
    }

    public String getSortColumnName() {
        return this.sortColumn != null && this.isColumnSortable(this.sortColumn) ? this.sortColumn.getName() : null;
    }

    @Override
    public void reset() {
        this.setSortOrder(this.defaultSortOrder);
        this.setSortColumn(this.defaultSortColumn);
    }
}

