/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.InternalTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.AbstractFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.DetailFeatureWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.FeatureEvent;
import java.util.List;
import java.util.Map;

public class DetailFeatureHandler<K, R extends Record<K>>
extends AbstractFeatureHandler<K, R, DetailFeature<K, R>> {
    private ButtonWidget createButton;
    private ButtonWidget deleteButton;
    private DetailFeatureWidget<K, R> widget;
    private static final String CREATE_VIEW = "Create";
    private static final String EDIT_VIEW = "Edit";
    private static final String RECORD_ID_TOKEN = "id";

    public DetailFeatureHandler(InternalTable<K, R> table, DetailFeature<K, R> detailFeature) {
        super(table, detailFeature);
        this.buildWidgets();
    }

    private void buildWidgets() {
        this.createButton = new ButtonWidget(CREATE_VIEW, new ClickHandler(){

            public void onClick(ClickEvent event) {
                DetailFeatureHandler.this.handleCreateButtonClick(event);
            }
        });
        this.createButton.addStyleDependentName("action-button");
        this.getTable().registerWidgetOnActionContainer((Widget)this.createButton);
        this.deleteButton = new ButtonWidget("Delete", new ClickHandler(){

            public void onClick(ClickEvent event) {
                DetailFeatureHandler.this.handleDeleteButtonClick(event);
            }
        });
        this.deleteButton.addStyleDependentName("dataloss-button");
        this.getTable().registerWidgetOnActionContainer((Widget)this.deleteButton);
        this.updateButtons();
    }

    @Override
    public void refresh() {
        for (Column column : this.getInternalTable().getColumns()) {
            List<Widget> widgetList;
            if (!((DetailFeature)this.getFeature()).hasDetailLink(column) || (widgetList = this.getInternalTable().getWidgetsForColumn(column)) == null) continue;
            for (Widget widget : widgetList) {
                if (!(widget instanceof HasClickHandlers)) continue;
                ((HasClickHandlers)widget).addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        DetailFeatureHandler.this.handleDetailLinkClicked(event);
                    }
                });
                widget.setStyleName("table-data-link");
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean canCreate = ((DetailFeature)this.getFeature()).showCreateButton();
        this.createButton.setVisible(canCreate);
        this.createButton.setEnabled(canCreate);
        boolean canDelete = ((DetailFeature)this.getFeature()).showDeleteButton();
        this.deleteButton.setVisible(canDelete);
        this.deleteButton.setEnabled(canDelete);
    }

    @Override
    public Map<String, String> getAnchorTokens() {
        Map<String, String> tokens = super.getAnchorTokens();
        if (this.isDetailViewShowing() && !this.widget.isNewRecord()) {
            Object key = this.widget.getRecord().getKey();
            String keyValue = ((DetailFeature)this.getFeature()).getKeySerializer().toString(key);
            if (!this.isBlank(keyValue)) {
                tokens.put(RECORD_ID_TOKEN, keyValue);
            }
        }
        return tokens;
    }

    @Override
    public void setAnchor(TableAnchor anchor) {
        String viewName = anchor.getViewName();
        if (CREATE_VIEW.equals(viewName)) {
            this.getInternalTable().showView((Widget)new LabelWidget(""), viewName);
            this.showCreateView();
        } else if (EDIT_VIEW.equals(viewName)) {
            this.getInternalTable().showView((Widget)new LabelWidget(""), viewName);
            String id = anchor.getTokens().get(RECORD_ID_TOKEN);
            Object key = null;
            try {
                key = ((DetailFeature)this.getFeature()).getKeySerializer().fromString(id);
            }
            catch (Exception e) {
                this.handleShowDetailPageFailure(e);
                return;
            }
            this.getInternalTable().getRecordForKey(key, new NeptuneAsyncCallback<R>(){

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    DetailFeatureHandler.this.handleShowDetailPageFailure(caught);
                }

                @Override
                public void onNeptuneSuccess(R result) {
                    DetailFeatureHandler.this.showDetailView(result);
                }
            });
        }
    }

    public void showCreateView() {
        this.performCreateAction(false);
    }

    public void showDetailView(R record) {
        this.performShowDetailViewAction(record, false);
    }

    private boolean isDetailViewShowing() {
        return this.widget != null && this.getInternalTable().isShowingView((Widget)this.widget);
    }

    private void handleCreateButtonClick(ClickEvent event) {
        this.performCreateAction(true);
    }

    private void performCreateAction(final boolean userEvent) {
        ((DetailFeature)this.getFeature()).getNew(new AsyncCallback<R>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onSuccess(R result) {
                DetailFeatureHandler.this.showDetailView(result, true, userEvent);
            }
        });
    }

    private void handleDeleteButtonClick(ClickEvent event) {
        ((DetailFeature)this.getFeature()).delete(this.getTable().getSelectedRecords(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            @Override
            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            @Override
            public void onNeptuneSuccess(Void result) {
                DetailFeatureHandler.this.fireFeatureEvent(new FeatureEvent(false));
            }
        });
    }

    private void handleDetailLinkClicked(ClickEvent event) {
        Widget sender = (Widget)event.getSource();
        Object record = this.getInternalTable().getRecordForWidget(sender);
        this.performShowDetailViewAction(record, true);
    }

    private void performShowDetailViewAction(R record, boolean userEvent) {
        this.showDetailView(record, false, userEvent);
    }

    void handleViewCancel() {
        this.showListView();
    }

    void handleViewSaveSuccess() {
        this.showListView();
    }

    void handleViewSaveFailure(Throwable error) {
    }

    void handleViewRevert() {
    }

    private void handleShowDetailPageFailure(Throwable error) {
        Window.alert((String)error.getLocalizedMessage());
    }

    private void showDetailView(R record, boolean newRecord, boolean userEvent) {
        this.widget = new DetailFeatureWidget(this, record, newRecord);
        String viewName = newRecord ? CREATE_VIEW : EDIT_VIEW;
        this.getInternalTable().showView((Widget)this.widget, viewName);
        this.fireFeatureEvent(new FeatureEvent(userEvent));
    }

    private void showListView() {
        if (this.getTable().hasPageFeature()) {
            this.getTable().getPageFeature().setPageNumber(1);
        }
        this.getInternalTable().showListView();
        this.fireFeatureEvent(new FeatureEvent());
    }
}

