/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.DetailFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

class DetailFeatureWidget<K, R extends Record<K>>
extends Composite {
    private final DetailFeatureHandler<K, R> handler;
    private final R record;
    private final boolean newRecord;
    private VerticalContainer container;
    private DetailView<K, R> detailView;

    public DetailFeatureWidget(DetailFeatureHandler<K, R> handler, R record, boolean isNewRecord) {
        this.handler = handler;
        this.record = record;
        this.newRecord = isNewRecord;
        this.initialize();
        this.initWidget((Widget)this.container);
    }

    private void initialize() {
        this.container = new VerticalContainer();
        DetailViewCallback callback = new DetailViewCallback<K, R>(){

            @Override
            public void cancel(DetailView<K, R> view) {
                DetailFeatureWidget.this.handleViewCancel();
            }

            @Override
            public void revert(DetailView<K, R> view) {
                DetailFeatureWidget.this.handleViewRevert();
            }

            @Override
            public void save(DetailView<K, R> view) {
                DetailFeatureWidget.this.handleViewSave();
            }
        };
        this.detailView = ((DetailFeature)this.handler.getFeature()).getView(this.record, callback);
        this.container.add(this.detailView.getWidget());
    }

    public boolean isNewRecord() {
        return this.newRecord;
    }

    public R getRecord() {
        return this.record;
    }

    public DetailView<K, R> getDetailView() {
        return this.detailView;
    }

    protected void onUnload() {
        this.detailView.release();
    }

    private void handleViewCancel() {
        this.handler.handleViewCancel();
    }

    private void handleViewSave() {
        this.detailView.commit();
        ((DetailFeature)this.handler.getFeature()).save(this.record, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                DetailFeatureWidget.this.detailView.saveFailed(caught);
                DetailFeatureWidget.this.handler.handleViewSaveFailure(caught);
            }

            public void onSuccess(Void result) {
                DetailFeatureWidget.this.handler.handleViewSaveSuccess();
            }
        });
    }

    private void handleViewRevert() {
        this.detailView.revert();
        this.handler.handleViewRevert();
    }
}

