/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.InternalTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.AbstractFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.FeatureEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.PageFeatureWidget;
import java.util.Map;

public class PageFeatureHandler<K, R extends Record<K>>
extends AbstractFeatureHandler<K, R, PageFeature> {
    private final PageFeatureWidget widget = new PageFeatureWidget(this);
    private static final String PAGE_NUMBER_ANCHOR_TOKEN = "PageNo";
    private static final String PAGE_SIZE_ANCHOR_TOKEN = "PageSize";

    public PageFeatureHandler(InternalTable<K, R> table, PageFeature pageFeature) {
        super(table, pageFeature);
        this.widget.setWidth("100%");
        this.getInternalTable().getPaginationPanel().setWidget((Widget)this.widget);
    }

    @Override
    protected void resetView() {
        this.widget.refresh();
    }

    @Override
    public void refresh() {
        this.widget.refresh();
    }

    @Override
    public Map<String, String> getAnchorTokens() {
        Map<String, String> tokenMap = super.getAnchorTokens();
        if (this.getInternalTable().isShowingListView()) {
            tokenMap.put(PAGE_NUMBER_ANCHOR_TOKEN, Integer.toString(((PageFeature)this.getFeature()).getPageNumber()));
            tokenMap.put(PAGE_SIZE_ANCHOR_TOKEN, Integer.toString(((PageFeature)this.getFeature()).getPageSize()));
        }
        return tokenMap;
    }

    @Override
    public void setAnchor(TableAnchor anchor) {
        String pageSizeValue;
        String pageNumberValue = anchor.getTokens().get(PAGE_NUMBER_ANCHOR_TOKEN);
        if (!this.isBlank(pageNumberValue)) {
            try {
                int pageNumber = Integer.parseInt(pageNumberValue);
                if (pageNumber > 0) {
                    ((PageFeature)this.getFeature()).setPageNumber(pageNumber);
                }
            }
            catch (Exception pageNumber) {
                // empty catch block
            }
        }
        if (!this.isBlank(pageSizeValue = anchor.getTokens().get(PAGE_SIZE_ANCHOR_TOKEN))) {
            try {
                int pageSize = Integer.parseInt(pageSizeValue);
                if (pageSize > 0) {
                    ((PageFeature)this.getFeature()).setPageSize(pageSize);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPageNumberText(Integer pageNumber) {
        this.widget.setPageNumberText(pageNumber);
    }

    protected void updatePage(int pageNumber, int size) {
        ((PageFeature)this.getFeature()).setPageNumber(pageNumber);
        ((PageFeature)this.getFeature()).setPageSize(size);
        this.fireFeatureEvent(new FeatureEvent());
    }
}

