/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.PageFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.PageFeatureImages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

class PageFeatureWidget
extends Composite {
    private final PageFeatureHandler<?, ?> handler;
    private final HorizontalContainer container;
    private final PageFeatureImages imageBundle;
    private HorizontalContainer pageSizePanel;
    private Grid pageSizeGrid;
    private HorizontalContainer pageNavigationPanel;
    private LabelWidget pageCountWidget;
    private ImageWidget leftLeftWidget;
    private ImageWidget leftWidget;
    private ImageWidget rightWidget;
    private ImageWidget rightRightWidget;
    private HorizontalContainer gotoPagePanel;
    private TextBoxWidget pageNumberWidget;

    public PageFeatureWidget(PageFeatureHandler<?, ?> handler) {
        this.handler = handler;
        this.container = new HorizontalContainer();
        this.imageBundle = (PageFeatureImages)GWT.create(PageFeatureImages.class);
        this.initialize();
        this.initWidget((Widget)this.container);
    }

    private void initialize() {
        this.container.setSpacing(15);
        this.container.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.pageSizePanel = this.buildPageSizePanel();
        this.container.add((Widget)this.pageSizePanel);
        this.container.setCellHorizontalAlignment((Widget)this.pageSizePanel, HasHorizontalAlignment.ALIGN_LEFT);
        this.pageNavigationPanel = this.buildPageNavigationPanel();
        this.container.add((Widget)this.pageNavigationPanel);
        this.container.setCellHorizontalAlignment((Widget)this.pageNavigationPanel, HasHorizontalAlignment.ALIGN_LEFT);
        this.gotoPagePanel = this.buildGotoPagePanel();
        this.container.add((Widget)this.gotoPagePanel);
        this.container.setCellHorizontalAlignment((Widget)this.gotoPagePanel, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    private HorizontalContainer buildPageSizePanel() {
        HorizontalContainer panel = new HorizontalContainer();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        int[] pageSizes = ((PageFeature)this.handler.getFeature()).getPageSizes();
        int pageSizeCount = pageSizes.length;
        this.pageSizeGrid = new Grid(1, pageSizeCount);
        this.pageSizeGrid.setStyleName("table-nav-pageSizeTable");
        int i = 0;
        while (i < pageSizeCount) {
            this.pageSizeGrid.setWidget(0, i, (Widget)new LabelWidget(String.valueOf(pageSizes[i])));
            this.pageSizeGrid.getCellFormatter().setStyleName(0, i, "table-nav-pageSize-cell");
            ++i;
        }
        this.pageSizeGrid.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PageFeatureWidget.this.handlePageSizeGridClick(event);
            }
        });
        panel.add((Widget)this.pageSizeGrid);
        panel.setSpacing(3);
        LabelWidget suffixLabel = new LabelWidget("rows per page");
        suffixLabel.setStyleName("table-general-text");
        panel.add((Widget)suffixLabel);
        return panel;
    }

    private HorizontalContainer buildPageNavigationPanel() {
        HorizontalContainer panel = new HorizontalContainer();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        panel.setSpacing(5);
        this.leftLeftWidget = new ImageWidget();
        this.leftLeftWidget.setStyleName("table-nav-button");
        this.leftLeftWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PageFeatureWidget.this.handleGoToFirstPageClick(event);
            }
        });
        this.imageBundle.firstPageDisabled().applyTo((Image)this.leftLeftWidget);
        panel.add((Widget)this.leftLeftWidget);
        this.leftWidget = new ImageWidget();
        this.leftWidget.setStyleName("table-nav-button");
        this.leftWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PageFeatureWidget.this.handleGoToPreviousPageClick(event);
            }
        });
        this.imageBundle.previousPageDisabled().applyTo((Image)this.leftWidget);
        panel.add((Widget)this.leftWidget);
        this.pageCountWidget = new LabelWidget("");
        this.pageCountWidget.setStyleName("table-general-text");
        panel.add((Widget)this.pageCountWidget);
        this.rightWidget = new ImageWidget();
        this.rightWidget.setStyleName("table-nav-button");
        this.rightWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PageFeatureWidget.this.handleGoToNextPageClick(event);
            }
        });
        this.imageBundle.nextPageDisabled().applyTo((Image)this.rightWidget);
        panel.add((Widget)this.rightWidget);
        this.rightRightWidget = new ImageWidget();
        this.rightRightWidget.setStyleName("table-nav-button");
        this.rightRightWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PageFeatureWidget.this.handleGoToLastPageClick(event);
            }
        });
        this.imageBundle.lastPageDisabled().applyTo((Image)this.rightRightWidget);
        panel.add((Widget)this.rightRightWidget);
        return panel;
    }

    private HorizontalContainer buildGotoPagePanel() {
        HorizontalContainer panel = new HorizontalContainer();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        LabelWidget gotoPageLabelWidget = new LabelWidget("go to page:");
        gotoPageLabelWidget.setStyleName("table-general-text");
        panel.add((Widget)gotoPageLabelWidget);
        this.pageNumberWidget = new TextBoxWidget();
        this.pageNumberWidget.setMaxLength(5);
        this.pageNumberWidget.setVisibleLength(2);
        this.pageNumberWidget.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                PageFeatureWidget.this.handlePageNumberKeyPress(event);
            }
        });
        panel.add((Widget)this.pageNumberWidget);
        return panel;
    }

    private void handlePageSizeGridClick(ClickEvent event) {
        int clickedCellIndex = this.pageSizeGrid.getCellForEvent(event).getCellIndex();
        int size = ((PageFeature)this.handler.getFeature()).getPageSizes()[clickedCellIndex];
        if (size == ((PageFeature)this.handler.getFeature()).getPageSize()) {
            return;
        }
        this.handler.updatePage(1, size);
    }

    private void handleGoToFirstPageClick(ClickEvent event) {
        if (((PageFeature)this.handler.getFeature()).getPageNumber() == 1) {
            return;
        }
        int pageNumber = 1;
        int size = ((PageFeature)this.handler.getFeature()).getPageSize();
        this.handler.updatePage(pageNumber, size);
    }

    private void handleGoToPreviousPageClick(ClickEvent event) {
        if (((PageFeature)this.handler.getFeature()).getPageNumber() == 1) {
            return;
        }
        int pageCount = this.getTotalPages();
        int size = ((PageFeature)this.handler.getFeature()).getPageSize();
        int pageNumber = ((PageFeature)this.handler.getFeature()).getPageNumber() - 1;
        if (pageNumber <= 0) {
            pageNumber = 1;
        } else if (pageCount > 0 && pageNumber > pageCount) {
            pageNumber = pageCount;
        }
        this.handler.updatePage(pageNumber, size);
    }

    private void handleGoToNextPageClick(ClickEvent event) {
        int pageCount = this.getTotalPages();
        if (pageCount > 0 && ((PageFeature)this.handler.getFeature()).getPageNumber() == pageCount) {
            return;
        }
        int size = ((PageFeature)this.handler.getFeature()).getPageSize();
        int pageNumber = ((PageFeature)this.handler.getFeature()).getPageNumber() + 1;
        if (pageCount > 0 && pageNumber > pageCount) {
            pageNumber = pageCount;
        }
        this.handler.updatePage(pageNumber, size);
    }

    private void handleGoToLastPageClick(ClickEvent event) {
        int pageCount = this.getTotalPages();
        if (pageCount > 0 && ((PageFeature)this.handler.getFeature()).getPageNumber() == pageCount) {
            return;
        }
        int size = ((PageFeature)this.handler.getFeature()).getPageSize();
        if (pageCount <= 0) {
            pageCount = 1;
        }
        this.handler.updatePage(pageCount, size);
    }

    private void handlePageNumberKeyPress(KeyPressEvent event) {
        if (event.getCharCode() == '\r') {
            int pageNumber = 0;
            try {
                pageNumber = Integer.parseInt(this.pageNumberWidget.getText());
            }
            catch (NumberFormatException e) {
                Window.alert((String)"Please enter a valid page number");
                return;
            }
            if (pageNumber <= 0) {
                Window.alert((String)"Please enter a valid page number");
                return;
            }
            int totalPages = this.getTotalPages();
            if (totalPages > 0 && pageNumber > totalPages) {
                pageNumber = totalPages;
                this.setPageNumberText(pageNumber);
            }
            int size = ((PageFeature)this.handler.getFeature()).getPageSize();
            this.handler.updatePage(pageNumber, size);
        }
    }

    public void refresh() {
        this.updatePageSizePanel();
        this.updatePageNavigationPanel();
        this.updatePageNumberText();
    }

    public void setPageNumberText(Integer pageNumber) {
        String text = pageNumber == null ? "" : pageNumber.toString();
        this.pageNumberWidget.setText(text);
    }

    private void updatePageNumberText() {
        int pageNumber = ((PageFeature)this.handler.getFeature()).getPageNumber();
        this.setPageNumberText(pageNumber);
    }

    private void updatePageSizePanel() {
        int[] pageSizes = ((PageFeature)this.handler.getFeature()).getPageSizes();
        int size = ((PageFeature)this.handler.getFeature()).getPageSize();
        int i = 0;
        while (i < pageSizes.length) {
            String style = size == pageSizes[i] ? "table-nav-currentPageSize-cell" : "table-nav-pageSize-cell";
            this.pageSizeGrid.getCellFormatter().setStyleName(0, i, style);
            ++i;
        }
    }

    private void updatePageNavigationPanel() {
        int totalPages = this.getTotalPages();
        int currentPage = ((PageFeature)this.handler.getFeature()).getPageNumber();
        String pageCount = totalPages <= 0 ? "-" : Integer.toString(totalPages);
        this.pageCountWidget.setText("page " + currentPage + " of " + pageCount);
        AbstractImagePrototype image = null;
        boolean isLeftEnabled = currentPage > 1;
        image = isLeftEnabled ? this.imageBundle.firstPageEnabled() : this.imageBundle.firstPageDisabled();
        image.applyTo((Image)this.leftLeftWidget);
        image = isLeftEnabled ? this.imageBundle.previousPageEnabled() : this.imageBundle.previousPageDisabled();
        image.applyTo((Image)this.leftWidget);
        boolean isRightEnabled = totalPages <= 0 || currentPage < totalPages;
        image = isRightEnabled ? this.imageBundle.lastPageEnabled() : this.imageBundle.lastPageDisabled();
        image.applyTo((Image)this.rightRightWidget);
        image = isRightEnabled ? this.imageBundle.nextPageEnabled() : this.imageBundle.nextPageDisabled();
        image.applyTo((Image)this.rightWidget);
    }

    private int getTotalPages() {
        int recordCount = ((PageFeature)this.handler.getFeature()).getRecordCount();
        if (recordCount < 0) {
            return -1;
        }
        int recordsPerPage = ((PageFeature)this.handler.getFeature()).getPageSize();
        int totalPages = recordCount / recordsPerPage;
        if (recordCount % recordsPerPage > 0) {
            ++totalPages;
        }
        if (totalPages <= 0) {
            totalPages = 1;
        }
        return totalPages;
    }
}

