/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.InternalTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.AbstractFeatureHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.FeatureEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.SortFeatureImages;
import java.util.Map;

public class SortFeatureHandler<K, R extends Record<K>>
extends AbstractFeatureHandler<K, R, SortFeature<K, R>> {
    private final SortFeatureImages bundle = (SortFeatureImages)GWT.create(SortFeatureImages.class);
    private final ImageWidget sortImage = new ImageWidget();
    private static final String SORT_ORDER_ANCHOR_TOKEN = "SortOrder";
    private static final String SORT_COLUMN_ANCHOR_TOKEN = "SortColumn";

    public SortFeatureHandler(InternalTable<K, R> table, SortFeature<K, R> sortFeature) {
        super(table, sortFeature);
    }

    @Override
    public void initialize() {
        for (final Column column : this.getInternalTable().getColumns()) {
            if (!((SortFeature)this.getFeature()).isColumnSortable(column)) continue;
            Label headerLabel = this.getInternalTable().getHeaderWidgetLabelForColumn(column);
            headerLabel.setStyleName("table-header-sortable-text");
            headerLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SortFeatureHandler.this.handleColumnHeaderLabelClick(column, event);
                }
            });
        }
    }

    @Override
    protected void resetView() {
        this.sortImage.removeFromParent();
    }

    @Override
    public void refresh() {
        HorizontalPanel panel;
        Column column = ((SortFeature)this.getFeature()).getSortColumn();
        SortOrder sortOrder = ((SortFeature)this.getFeature()).getSortOrder();
        this.sortImage.removeFromParent();
        boolean ascending = sortOrder == SortOrder.ASCENDING;
        AbstractImagePrototype prototype = ascending ? this.bundle.ascending() : this.bundle.descending();
        prototype.applyTo((Image)this.sortImage);
        if (column != null && sortOrder != null && (panel = this.getInternalTable().getHeaderWidgetForColumn(column)) != null) {
            panel.add((Widget)this.sortImage);
        }
    }

    @Override
    public Map<String, String> getAnchorTokens() {
        Map<String, String> tokenMap = super.getAnchorTokens();
        if (this.getInternalTable().isShowingListView() && ((SortFeature)this.getFeature()).getSortOrder() != null && ((SortFeature)this.getFeature()).getSortColumn() != null) {
            tokenMap.put(SORT_ORDER_ANCHOR_TOKEN, ((SortFeature)this.getFeature()).getSortOrder().name());
            tokenMap.put(SORT_COLUMN_ANCHOR_TOKEN, ((SortFeature)this.getFeature()).getSortColumn().getName());
        }
        return tokenMap;
    }

    @Override
    public void setAnchor(TableAnchor anchor) {
        String order = anchor.getTokens().get(SORT_ORDER_ANCHOR_TOKEN);
        if (!this.isBlank(order)) {
            try {
                ((SortFeature)this.getFeature()).setSortOrder(SortOrder.valueOf(order));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String columnName = anchor.getTokens().get(SORT_COLUMN_ANCHOR_TOKEN);
        Column match = null;
        if (!this.isBlank(columnName)) {
            for (Column currentColumn : this.getInternalTable().getColumns()) {
                if (!((SortFeature)this.getFeature()).isColumnSortable(currentColumn) || !columnName.equals(currentColumn.getName())) continue;
                match = currentColumn;
                break;
            }
            if (match != null) {
                ((SortFeature)this.getFeature()).setSortColumn(match);
            }
        }
    }

    private void handleColumnHeaderLabelClick(Column<?, R> column, ClickEvent event) {
        SortOrder order = ((SortFeature)this.getFeature()).getDefaultSortOrder();
        if (((SortFeature)this.getFeature()).getSortColumn().equals(column)) {
            SortOrder oldOrder = ((SortFeature)this.getFeature()).getSortOrder();
            order = oldOrder != SortOrder.ASCENDING ? SortOrder.ASCENDING : SortOrder.DESCENDING;
        }
        ((SortFeature)this.getFeature()).setSortColumn(column);
        ((SortFeature)this.getFeature()).setSortOrder(order);
        this.fireFeatureEvent(new FeatureEvent());
    }
}

