/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainerImages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainerImagesRTL;
import org.cobogw.gwt.user.client.ui.RoundedPanel;

public class RoundedDisclosureContainer
extends DisclosureContainer {
    private static final String STYLENAME_DEFAULT = "wtk-RoundedDisclosureContainer";
    private static final String STYLENAME_LABEL_CORNERS = "label-corners";
    private static final String STYLENAME_LABEL = "label";

    public RoundedDisclosureContainer(String headerText) {
        this(headerText, false);
    }

    public RoundedDisclosureContainer(String headerText, boolean isOpen) {
        this(RoundedDisclosureContainer.createDefaultImages(), headerText, isOpen);
    }

    public RoundedDisclosureContainer(Widget header) {
        this(header, false);
    }

    public RoundedDisclosureContainer(Widget header, boolean isOpen) {
        this(RoundedDisclosureContainer.createDefaultImages(), header, isOpen);
    }

    public RoundedDisclosureContainer(DisclosurePanelImages images, String headerText, boolean isOpen) {
        this(images, (Widget)new LabelWidget(headerText), isOpen);
    }

    public RoundedDisclosureContainer(DisclosurePanelImages images, Widget header, boolean isOpen) {
        this.initialize(header, images);
        this.setOpen(isOpen);
    }

    private void initialize(Widget headerWidget, DisclosurePanelImages images) {
        this.setStyleName(STYLENAME_DEFAULT);
        RoundedPanelHeader header = new RoundedPanelHeader(headerWidget, images);
        this.setHeader((Widget)header);
    }

    private static DisclosurePanelImages createDefaultImages() {
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            return (DisclosurePanelImages)GWT.create(RoundedDisclosureContainerImagesRTL.class);
        }
        return (DisclosurePanelImages)GWT.create(RoundedDisclosureContainerImages.class);
    }

    private class RoundedPanelHeader
    extends Composite
    implements OpenHandler<DisclosureContainer>,
    CloseHandler<DisclosureContainer> {
        private final Widget headerWidget;
        private final DisclosurePanelImages images;
        private final Image iconImage;

        private RoundedPanelHeader(Widget headerWidget, DisclosurePanelImages images) {
            this.images = images;
            this.headerWidget = headerWidget;
            this.iconImage = RoundedDisclosureContainer.this.isOpen() ? images.disclosurePanelOpen().createImage() : images.disclosurePanelClosed().createImage();
            RoundedPanel container = new RoundedPanel(15, 3);
            container.setCornerStyleName(RoundedDisclosureContainer.STYLENAME_LABEL_CORNERS);
            this.initWidget((Widget)container);
            HorizontalContainer contents = new HorizontalContainer();
            container.setWidget((Widget)contents);
            contents.addStyleName(RoundedDisclosureContainer.STYLENAME_LABEL);
            contents.setWidth("100%");
            contents.setSpacing(3);
            contents.add((Widget)this.iconImage);
            contents.add(this.headerWidget);
            contents.setCellVerticalAlignment((Widget)this.iconImage, HasVerticalAlignment.ALIGN_MIDDLE);
            contents.setCellHorizontalAlignment((Widget)this.iconImage, HasHorizontalAlignment.ALIGN_CENTER);
            contents.setCellWidth((Widget)this.iconImage, String.valueOf(this.iconImage.getWidth() + 2) + "px");
            RoundedDisclosureContainer.this.addOpenHandler(this);
            RoundedDisclosureContainer.this.addCloseHandler(this);
            this.setStyle();
        }

        public Widget getHeaderWidget() {
            return this.headerWidget;
        }

        public final void onClose(CloseEvent<DisclosureContainer> event) {
            this.setStyle();
        }

        public final void onOpen(OpenEvent<DisclosureContainer> event) {
            this.setStyle();
        }

        private void setStyle() {
            if (RoundedDisclosureContainer.this.isOpen()) {
                this.images.disclosurePanelOpen().applyTo(this.iconImage);
            } else {
                this.images.disclosurePanelClosed().applyTo(this.iconImage);
            }
        }
    }
}

