/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ppfm.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PPFM_Utils {
    private static String url;
    private static String user;
    private static String pwd;
    Connection con;

    static Connection getConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection(url, user, pwd);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error connecting to database");
        }
        return conn;
    }

    static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public PPFM_Utils(Connection con) {
        this.con = con;
    }

    private boolean pg_is_in_recovery() throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery("select pg_is_in_recovery()");
            if (rs.next()) {
                boolean bl = rs.getBoolean(1);
                return bl;
            }
            return false;
        }
        finally {
            if (st != null) {
                st.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    private Integer pg_stat_replication_count() throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery("select count(*) from pg_stat_replication where state='streaming' and replay_location is not null");
            if (rs.next()) {
                Integer n = rs.getInt(1);
                return n;
            }
            return null;
        }
        finally {
            if (st != null) {
                st.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Must provide host as a parameter.");
            System.exit(1);
        }
        url = "jdbc:postgresql://" + args[0] + ":5444/ttv";
        user = args.length >= 2 ? args[1] : "edb";
        pwd = args.length >= 3 ? args[2] : "n2bbsys";
        Connection conn = PPFM_Utils.getConnection();
        if (conn == null) {
            System.out.println("Cannot connect to host.");
            System.exit(1);
        }
        PPFM_Utils test = new PPFM_Utils(conn);
        System.out.println(test.pg_stat_replication_count());
        PPFM_Utils.closeConnection(conn);
        System.exit(0);
    }
}

