/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.systinet.wsdl.com.n2bb.manager.webservice.common._package;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService_getPackages_comN2BbManagerWebserviceCommonServiceException_Fault;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathAPIException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathDispatcher;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PackageIngestionDispatcher
extends MediaPathDispatcher {
    private static final Logger logger = Logger.getLogger(PackageIngestionDispatcher.class);

    public PackageIngestionDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected WorkflowMessage generateResponse(IMessage msg, URL url) throws DispatcherException {
        logger.debug((Object)("payload=" + msg.getPayload().getContent()));
        try {
            Document doc = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            String providerId = null;
            String assetId = null;
            String minorVersion = null;
            String majorVersion = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
            if (parameterListNode != null) {
                Node majorVersionNode;
                Node minorVersionNode;
                Node assetIdNode;
                Node providerIdNode = (Node)xpath.evaluate("Parameter[@Name='ProviderId']", parameterListNode, XPathConstants.NODE);
                if (providerIdNode != null) {
                    providerId = (String)xpath.evaluate("Value", providerIdNode, XPathConstants.STRING);
                }
                if ((assetIdNode = (Node)xpath.evaluate("Parameter[@Name='AssetId']", parameterListNode, XPathConstants.NODE)) != null) {
                    assetId = (String)xpath.evaluate("Value", assetIdNode, XPathConstants.STRING);
                }
                if ((minorVersionNode = (Node)xpath.evaluate("Parameter[@Name='MinorVersion']", parameterListNode, XPathConstants.NODE)) != null) {
                    minorVersion = (String)xpath.evaluate("Value", minorVersionNode, XPathConstants.STRING);
                }
                if ((majorVersionNode = (Node)xpath.evaluate("Parameter[@Name='MajorVersion']", parameterListNode, XPathConstants.NODE)) != null) {
                    majorVersion = (String)xpath.evaluate("Value", majorVersionNode, XPathConstants.STRING);
                }
            }
            Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
            String messUID = wfsMessageNode.getAttributes().getNamedItem("UID").getTextContent();
            String requestKey = wfsMessageNode.getAttributes().getNamedItem("RequestKey").getTextContent();
            logger.debug((Object)("messUID=" + messUID + ", requestKey=" + requestKey));
            WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(messUID), (IMessageKey)new MessageKeyImpl((Object)requestKey));
            WorkflowPayload payload = response.getPayload();
            try {
                SchedulerService service = this.getService(url);
                String packageId = this.getPackageId(service, providerId, assetId, minorVersion, majorVersion);
                payload.putValue("PackageId", packageId);
                response.setType(WorkflowMessage.MessageType.ack);
            }
            catch (MediaPathAPIException de) {
                logger.error((Object)"Error occurred whilce getting packages: ", (Throwable)de);
                StringWriter writer = new StringWriter();
                de.printStackTrace(new PrintWriter(writer));
                payload.putValue("error-message", de.getMessage());
                payload.putValue("error-stack", writer.toString());
                response.setType(WorkflowMessage.MessageType.nack);
            }
            return response;
        }
        catch (Exception e) {
            logger.error((Object)"Error while loading XML document", (Throwable)e);
            throw new DispatcherException((Throwable)e);
        }
    }

    private String getPackageId(SchedulerService service, String providerId, String assetId, String minorVersion, String majorVersion) throws MediaPathAPIException {
        _package[] packages;
        String packageId = "";
        try {
            packages = service.getPackages();
        }
        catch (SchedulerService_getPackages_comN2BbManagerWebserviceCommonServiceException_Fault e) {
            throw new MediaPathAPIException(e);
        }
        catch (RemoteException e) {
            throw new MediaPathAPIException(e);
        }
        for (int i = 0; i < packages.length; ++i) {
            boolean provId;
            boolean assId = packages[i].getAssetInfo().getAssetID().equals(assetId);
            if (!assId || !(provId = packages[i].getAssetInfo().getProviderID().equals(providerId))) continue;
            boolean majVer = packages[i].getAssetInfo().getVersionMajor().toString().equals(majorVersion);
            boolean minVer = packages[i].getAssetInfo().getVersionMinor().toString().equals(minorVersion);
            if (!majVer || !minVer) continue;
            packageId = packages[i].getId().toString();
            logger.debug((Object)("Package ingested, id=" + packageId));
            break;
        }
        return packageId;
    }
}

