/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.pmm.server;

import com.tandbergtv.cms.pmm.client.Alert;
import com.tandbergtv.cms.pmm.client.AlertList;
import com.tandbergtv.cms.pmm.client.IListAlerts;
import com.tandbergtv.cms.pmm.server.UIPropertyProvider;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ListAlertsImpl
implements IListAlerts,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(ListAlertsImpl.class);
    private static final String PROP_UPPER_LIMIT = "pmm.portlets.alerts.upperLimit";
    private static final long MILLSECS_PER_DAY = 86400000L;
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public String getRelativePath() {
        return "service/watchpoint/IListAlerts";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    public AlertList getAlerts() throws InsufficientRolesException {
        this.verifyAuthority();
        Integer upperLimitOnNumAlerts = null;
        try {
            UIPropertyProvider propProvider = new UIPropertyProvider();
            String numAlertsStr = propProvider.getInfo().get(PROP_UPPER_LIMIT);
            if (numAlertsStr != null && numAlertsStr.trim().length() != 0) {
                upperLimitOnNumAlerts = Integer.parseInt(numAlertsStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get upper limit for number of alerts [pmm.portlets.alerts.upperLimit] for Alerts List Portlet. Ignoring limit.", (Throwable)e);
        }
        AlertList alertList = new AlertList();
        int totalAlerts = 0;
        IScheduleNotifier notifier = (IScheduleNotifier)ServiceRegistry.getDefault().lookup(IScheduleNotifier.class);
        Collection notifications = notifier.getCurrentNotifications();
        if (notifications != null) {
            for (Notification n : notifications) {
                Collection messages = n.getMessages();
                if (messages == null) continue;
                totalAlerts += messages.size();
                for (String message : messages) {
                    Alert alert = new Alert();
                    alert.setText(message);
                    alert.setScheduleId(n.getSchedule().getId());
                    alert.setDate(n.getSchedule().getDate());
                    if (n.getSchedule() instanceof DistributionSchedule) {
                        alert.setPitchSchedule(true);
                        alert.setEntityName(this.getDestination(n.getSchedule()));
                    } else if (n.getSchedule() instanceof Planner) {
                        alert.setPitchSchedule(false);
                        alert.setEntityName(this.getSource(n.getSchedule()));
                    }
                    alertList.addAlert(alert);
                }
            }
        }
        alertList = this.sortAndLimit(alertList, upperLimitOnNumAlerts);
        alertList.setTotalAlerts(totalAlerts);
        return alertList;
    }

    private AlertList sortAndLimit(AlertList alertList, Integer upperLimitOnNumAlerts) {
        if (alertList.getAlerts().size() == 0) {
            return alertList;
        }
        AlertList aList = new AlertList();
        HashMap<Integer, List<Alert>> sortedAlerts = new HashMap<Integer, List<Alert>>();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(new Date());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        for (Alert a : alertList.getAlerts()) {
            long deltaDays = (a.getDate().getTime() - c.getTime().getTime()) / 86400000L;
            Integer diff = new Integer(String.valueOf(deltaDays));
            if (sortedAlerts.get(diff) != null) {
                ((List)sortedAlerts.get(diff)).add(a);
                continue;
            }
            ArrayList<Alert> alerts = new ArrayList<Alert>();
            alerts.add(a);
            sortedAlerts.put(diff, alerts);
        }
        int alertsPicked = 0;
        int i = 0;
        while (alertsPicked != upperLimitOnNumAlerts && alertsPicked != alertList.getAlerts().size()) {
            alertsPicked = this.addAlertsForDelta(i, sortedAlerts, upperLimitOnNumAlerts, alertsPicked, aList);
            if (alertsPicked < upperLimitOnNumAlerts && i > 0) {
                alertsPicked = this.addAlertsForDelta(-i, sortedAlerts, upperLimitOnNumAlerts, alertsPicked, aList);
            }
            ++i;
        }
        Collections.sort(aList.getAlerts(), new Comparator<Alert>(){

            @Override
            public int compare(Alert o1, Alert o2) {
                Date date1 = o1.getDate();
                Date date2 = o2.getDate();
                return date2.compareTo(date1);
            }
        });
        return aList;
    }

    private int addAlertsForDelta(int delta, Map<Integer, List<Alert>> sortedAlerts, int upperLimitOnNumAlerts, int alertsPicked, AlertList aList) {
        if (sortedAlerts.get(delta) != null) {
            List<Alert> alerts = sortedAlerts.get(delta);
            for (Alert a : alerts) {
                if (alertsPicked >= upperLimitOnNumAlerts) break;
                aList.addAlert(a);
                ++alertsPicked;
            }
        }
        return alertsPicked;
    }

    private String getDestination(Schedule schedule) {
        long contextId = schedule.getContextID();
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        return ((IContainer)cache.get((Serializable)Long.valueOf(contextId))).getContainerName();
    }

    private String getSource(Schedule schedule) {
        IPartnerManagement pm;
        Partner partner;
        long partnerId = schedule.getSourcePartnerID();
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        if (cache != null) {
            for (Serializable key : cache.getKeys()) {
                IContainer container = (IContainer)cache.get(key);
                long id = container.getContainerId();
                if (container.getContainerType() != ContainerType.PARTNER || id != partnerId) continue;
                return container.getContainerName();
            }
        }
        if ((partner = (pm = PartnerManager.getInstance()).getPartner(partnerId)) != null) {
            return partner.getName();
        }
        throw new ScheduleRuntimeException("Cannot find partner " + partnerId);
    }
}

