/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.asset;

import com.tandbergtv.cms.contentmgmt.service.asset.ITitleManager;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.AssociatedToTitleListException;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jms.JMSException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

@Stateless
public class TitleManager
implements ITitleManager {
    private static final String COMPONENT_NAME = "Content Management";
    private static final String ENTITY_NAME = null;
    @Resource
    private SessionContext sessionContext;

    @RolesAllowed(value={"AssetManagement_View"})
    public Title getTitle(Long titleId) {
        return this.getTitlePersistenceService().get((Serializable)titleId);
    }

    @RolesAllowed(value={"AssetManagement_View"})
    public Title getTitle(Long titleId, String version) throws SearchException {
        return this.getTitlePersistenceService().get((Serializable)titleId, version);
    }

    @RolesAllowed(value={"AssetManagement_Create"})
    public SaveResult createTitle(Title title) throws TitleValidationException, JMSException {
        return this.getPMMUIService().createTitle(title, COMPONENT_NAME, ENTITY_NAME, this.sessionContext.getCallerPrincipal().getName());
    }

    @RolesAllowed(value={"AssetManagement_Create"})
    public Title createTitleAsDraft(Title title) throws TitleValidationException {
        return this.getPMMUIService().createTitleAsDraft(title, COMPONENT_NAME, ENTITY_NAME, this.sessionContext.getCallerPrincipal().getName());
    }

    @RolesAllowed(value={"AssetManagement_Modify"})
    public SaveResult updateTitleMetadata(Title title, Long requestKey, String action, String listOfAssetIds) throws TitleValidationException, JMSException {
        return this.getPMMUIService().updateTitleMetadata(title, requestKey, action, listOfAssetIds, COMPONENT_NAME, ENTITY_NAME, this.sessionContext.getCallerPrincipal().getName());
    }

    @RolesAllowed(value={"AssetManagement_Modify"})
    public Title updateTitleMetadataAsDraft(Title title) throws TitleValidationException {
        return this.getPMMUIService().updateTitleMetadataAsDraft(title, COMPONENT_NAME, ENTITY_NAME, this.sessionContext.getCallerPrincipal().getName());
    }

    @RolesAllowed(value={"AssetManagement_Delete"})
    public boolean deleteTitle(Long titleId, boolean dissociateFromTitleLists) throws AssociatedToTitleListException {
        return this.getTitleService().delete(titleId, dissociateFromTitleLists);
    }

    @RolesAllowed(value={"AssetManagement_Modify"})
    public Title rollbackTitle(Long titleId, String version) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        return this.getTitleService().rollback(titleId, version, COMPONENT_NAME, ENTITY_NAME, this.sessionContext.getCallerPrincipal().getName());
    }

    @RolesAllowed(value={"AssetManagement_Modify"})
    public Title rollbackAndSaveAsDraft(Long titleId, String version) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        return this.getTitleService().rollbackAndSaveAsDraft(titleId, version, COMPONENT_NAME, ENTITY_NAME, this.sessionContext.getCallerPrincipal().getName());
    }

    @RolesAllowed(value={"AssetManagement_View"})
    public String previewTitle(Title title, Specification specification) throws TranslationException {
        String specName = specification.getAlias();
        InputStream styleSheetStream = specification.getPreviewStylesheet();
        Document doc = this.getTitleService().previewTitle(title, specName);
        String assetXmlStr = "";
        assetXmlStr = styleSheetStream != null ? this.transformDocument(doc, styleSheetStream) : this.getStringFromDocument(doc);
        return assetXmlStr;
    }

    @RolesAllowed(value={"AssetManagement_View"})
    public File getUnmappedFileRepository() {
        return this.getAssetsManager().getUnmappedFilesDirectory();
    }

    @RolesAllowed(value={"AssetManagement_View"})
    public List<File> getUnmappedFiles() throws IOException {
        return this.getAssetsManager().getUnmappedFiles();
    }

    private ITitlePersistenceService getTitlePersistenceService() {
        return (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
    }

    private ITitleService getTitleService() {
        return (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
    }

    private AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private IPMMUIService getPMMUIService() {
        return (IPMMUIService)ServiceRegistry.getDefault().lookup(IPMMUIService.class);
    }

    private String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String transformDocument(Document doc, InputStream stylesheetStream) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer(new StreamSource(stylesheetStream));
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

