/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.specification;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class AssetSpecificationManager
implements IAssetSpecificationManager {
    private static final String SPECIFICATION_NAME_PROPERTY = "specificationName";
    @EJB
    private IConfigurationService configurationService;
    private static final String PMM_FOLDER_NAME = "pmm";
    private static final String TABLE_CONFIG_FILE_NAME = "table-config.xml";
    private static String SPECIFICATION = "specification";

    public Collection<Specification> getAllSpecifications() {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        return specificationManager.getAllSpecifications();
    }

    public Specification getDefaultSpecification() {
        String spec;
        ISpecificationManager manager = this.getSpecificationManager();
        Collection specifications = manager.getAllSpecifications();
        if (specifications == null || specifications.size() == 0) {
            return null;
        }
        try {
            spec = PMMProperties.getInstance().getProperty(SPECIFICATION);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find configured specification: ", e);
        }
        ArrayList all = new ArrayList(specifications);
        for (Specification s : all) {
            if (!s.getName().equalsIgnoreCase(spec)) continue;
            return s;
        }
        return null;
    }

    public Specification getSpecification(String name) {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        Specification specification = specificationManager.getSpecificationByName(name);
        if (specification == null) {
            throw new RuntimeException("No specification with name: " + name + " exists.");
        }
        return specification;
    }

    public Table getTableConfiguration(String specificationName, String tableName) {
        TableConfig configuration = TableConfig.getInstance();
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        runtimeProperties.put(SPECIFICATION_NAME_PROPERTY, specificationName);
        File tableFile = this.configurationService.getFile(PMM_FOLDER_NAME, TABLE_CONFIG_FILE_NAME);
        return configuration.getTable(tableName, tableFile, runtimeProperties);
    }

    private ISpecificationManager getSpecificationManager() {
        return (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    }
}

