/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.titlelist;

import com.tandbergtv.cms.contentmgmt.service.titlelist.ITitleListManager;
import com.tandbergtv.cms.contentmgmt.service.titlelist.ITitleListSearch;
import com.tandbergtv.cms.contentmgmt.service.titlelist.TitleListErrorCode;
import com.tandbergtv.cms.contentmgmt.service.titlelist.TitleListValidationException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListPersistenceService;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.TitleList;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;

@Stateless
public class TitleListManager
implements ITitleListManager {
    private static String TITLELIST_PERSISTENCE_SERVICE = "TitleList Persistence Service";
    private int MAX_NAME_LENGTH = 50;
    private int MAX_DESCRIPTION_LENGTH = 255;
    private ITitleListSearch listSearchService = (ITitleListSearch)InjectionUtil.injectInstance((String)"cms/TitleListSearch/local", ITitleListSearch.class);

    @RolesAllowed(value={"AssetListManagement_View"})
    public TitleList get(long id) {
        return (TitleList)this.getPersistenceService().get((Serializable)Long.valueOf(id));
    }

    @RolesAllowed(value={"AssetListManagement_Modify"})
    public void addTitles(long titleListId, List<Long> titleIds) {
        this.getPersistenceService().addTitles(titleListId, titleIds);
    }

    @RolesAllowed(value={"AssetListManagement_Modify"})
    public void removeTitles(long titleListId, List<Long> titleIds) {
        this.getPersistenceService().removeTitles(titleListId, titleIds);
    }

    @RolesAllowed(value={"AssetListManagement_Create"})
    public TitleList create(TitleList titleList) throws TitleListValidationException {
        this.validate(titleList);
        return (TitleList)this.getPersistenceService().save((AssetList)titleList);
    }

    private void validate(TitleList titleList) throws TitleListValidationException {
        TitleListValidationException exception = new TitleListValidationException();
        if (titleList.getName() == null || titleList.getName().isEmpty()) {
            exception.add(TitleListErrorCode.NAME_REQUIRED);
        } else if (titleList.getName().length() > this.MAX_NAME_LENGTH) {
            exception.add(TitleListErrorCode.MAX_NAME_LENGTH_EXCEEDED);
        } else {
            String name = this.escapeChars(titleList.getName());
            TitleList tl = this.listSearchService.getTitleList(name);
            if (tl != null && !tl.equals((Object)titleList)) {
                exception.add(TitleListErrorCode.DUPLICATE_NAME);
            }
        }
        if (!titleList.getDescription().isEmpty() && titleList.getDescription().length() > this.MAX_DESCRIPTION_LENGTH) {
            exception.add(TitleListErrorCode.MAX_DESCRIPTION_LENGTH_EXCEEDED);
        }
        if (exception.getCodes().size() > 0) {
            throw exception;
        }
    }

    private String escapeChars(String name) {
        name = name.replaceAll("'", "''");
        return name;
    }

    @RolesAllowed(value={"AssetListManagement_Modify"})
    public TitleList update(TitleList titleList) throws TitleListValidationException {
        this.validate(titleList);
        return (TitleList)this.getPersistenceService().save((AssetList)titleList);
    }

    @RolesAllowed(value={"AssetListManagement_Delete"})
    public void delete(long titleListId) {
        this.getPersistenceService().delete((Serializable)Long.valueOf(titleListId));
    }

    private AssetListPersistenceService<TitleList> getPersistenceService() {
        return (AssetListPersistenceService)ServiceRegistry.getDefault().lookup(TITLELIST_PERSISTENCE_SERVICE);
    }
}

