/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.client.services.title.AddTitleToTitleListResult;
import com.tandbergtv.cms.portal.content.client.services.titlelist.TitleListException;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class AddTitleToTitleList
implements ITitleService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public void execute(List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        final TitleActionInput actionInput = (TitleActionInput)input;
        if (actionInput.getTitleListId() == 0L) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.selectTitleListError()));
            return;
        }
        ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
        service.addTitlesToTitleList(actionInput.getTitleListId(), titleIds, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof TitleListException) {
                    String errorCode = ((TitleListException)((Object)caught)).getErrorCode();
                    callback.onFailure((Throwable)new RuntimeException(AddTitleToTitleList.this.displayConstants.getString(errorCode)));
                } else {
                    callback.onFailure((Throwable)new RuntimeException(AddTitleToTitleList.this.displayConstants.addToTitleListErrorMsg()));
                }
            }

            public void onNeptuneSuccess(Void result) {
                callback.onSuccess((Object)new AddTitleToTitleListResult(actionInput.getSpec(), actionInput.getTitleListId()));
            }
        });
    }

    public String getDescription() {
        return this.displayConstants.addTitleToList();
    }

    public String getName() {
        return this.displayConstants.addTitleToListServiceName();
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        History.newItem((String)("Content.TitleLists.View?titleListId=" + ((AddTitleToTitleListResult)result).getTitleListId() + "&spec=" + ((AddTitleToTitleListResult)result).getSpec()));
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return inputData.getTitleListId() != 0L;
    }
}

