/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;
import java.util.Map;

public class RunTemplate
implements ITitleService {
    private String NEWLINE_CHAR = "\n";
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public void execute(List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        if (serviceParameter == null || serviceParameter.isEmpty()) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.runTemplateServiceTemplateSelectionError()));
            return;
        }
        ITitleTemplateServiceAsync service = (ITitleTemplateServiceAsync)GWT.create(ITitleTemplateService.class);
        service.sendWorkOrderCreateMessage(titleIds, serviceParameter, (AsyncCallback<WorkOrderCreateResponse>)new NeptuneAsyncCallback<WorkOrderCreateResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(WorkOrderCreateResponse response) {
                callback.onSuccess((Object)RunTemplate.this.prepareResult(response));
            }
        });
    }

    private IOperationResult prepareResult(WorkOrderCreateResponse response) {
        StringBuilder sb = new StringBuilder();
        if (response.getQueuedWorkOrders().size() > 0) {
            sb.append(this.displayConstants.runTemplateServiceSuccess());
            StringBuilder ids = new StringBuilder();
            for (long id : response.getQueuedWorkOrders()) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            sb.append(ids.toString());
        }
        if (response.getFailedIds().size() > 0) {
            sb.append(this.NEWLINE_CHAR);
            sb.append(this.displayConstants.runTemplateServiceFailure());
            StringBuilder failedIds = new StringBuilder();
            for (Map.Entry<Long, String> entry : response.getFailedIds().entrySet()) {
                if (failedIds.length() > 0) {
                    failedIds.append(this.NEWLINE_CHAR);
                }
                failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
            }
            sb.append(failedIds.toString());
        }
        return new RunTemplateResult(sb.toString());
    }

    public String getDescription() {
        return this.displayConstants.runTemplateServiceDescription();
    }

    public String getName() {
        return this.displayConstants.runTemplateServiceName();
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
        ITitleTemplateServiceAsync service = (ITitleTemplateServiceAsync)GWT.create(ITitleTemplateService.class);
        service.getTemplates((AsyncCallback<?>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<String> result) {
                callback.onSuccess(result);
            }
        });
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }

    private class RunTemplateResult
    implements IOperationResult {
        String message;

        public RunTemplateResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

