/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.titlelist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.client.services.titlelist.RunTemplateResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;
import java.util.Map;

public class RunTemplate
implements ITitleListService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private String NEWLINE_CHAR = "\n";

    public void execute(List<Long> ids, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        if (serviceParameter == null || serviceParameter.isEmpty()) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.titleListRunTemplateTemplateSelectionError()));
            return;
        }
        ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService.class);
        service.sendWorkOrderCreateMessage(ids, serviceParameter, (AsyncCallback<WorkOrderCreateResponse>)new NeptuneAsyncCallback<WorkOrderCreateResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(WorkOrderCreateResponse result) {
                callback.onSuccess((Object)RunTemplate.this.prepareResult(result));
            }
        });
    }

    public String getDescription() {
        return this.displayConstants.titleListRunTemplateServiceDescription();
    }

    public String getName() {
        return this.displayConstants.titleListRunTemplateServiceName();
    }

    public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
        ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService.class);
        service.getTemplates((AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<String> result) {
                callback.onSuccess(result);
            }
        });
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    private IOperationResult prepareResult(WorkOrderCreateResponse response) {
        StringBuilder sb = new StringBuilder();
        if (response.getQueuedWorkOrders().size() > 0) {
            sb.append(this.displayConstants.titleListRunTemplateSuccessPrefix());
            StringBuilder ids = new StringBuilder();
            for (long id : response.getQueuedWorkOrders()) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            sb.append(ids.toString());
        }
        if (response.getFailedIds().size() > 0) {
            sb.append(this.NEWLINE_CHAR);
            sb.append(this.displayConstants.titleListRunTemplateFailurePrefix());
            StringBuilder failedIds = new StringBuilder();
            for (Map.Entry<Long, String> entry : response.getFailedIds().entrySet()) {
                if (failedIds.length() > 0) {
                    failedIds.append(this.NEWLINE_CHAR);
                }
                failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
            }
            sb.append(failedIds.toString());
        }
        return new RunTemplateResult(sb.toString());
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }
}

