/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.model.UiColumn;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.EditLinkListener;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class UiAssetTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private static String TABLE_NAME = "assetList";
    private TitleListPanel view;
    private List<UiColumn> uiColumns;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    private SortOrder defaultSortOrder;
    private Column<?, TitleRecord> defaultSortColumn;
    private List<Column<?, TitleRecord>> sortableColumns = new ArrayList();
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<Long, TitleRecord> sortFeature;

    public UiAssetTableDataProvider(TitleListPanel view) {
        this.view = view;
    }

    public void init(final AsyncCallback<Void> callback) {
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(TABLE_NAME, this.view.getSpecificationName(), (AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                UiAssetTableDataProvider.this.defaultSortOrder = SortOrder.valueOf((String)table.getDefaultSortingOrder());
                UiAssetTableDataProvider.this.uiColumns = table.getColumns();
                if (UiAssetTableDataProvider.this.uiColumns != null) {
                    for (UiColumn uiColumn : UiAssetTableDataProvider.this.uiColumns) {
                        String colInternalName = TableColumnNameHelper.getColumnName(uiColumn.getName(), uiColumn.getSectionName());
                        ColumnBase<String, TitleRecord> column = new ColumnBase<String, TitleRecord>(colInternalName, uiColumn.getDisplayName()){

                            public View<String> getView(TitleRecord record) {
                                UiTitle t = record.getTitle();
                                for (UiField f : t.getAsset().getFields()) {
                                    String colInternalName = TableColumnNameHelper.getColumnName(f.getName(), f.getParentAssetType());
                                    if (!colInternalName.equals(this.getName())) continue;
                                    LabelStringView view = new LabelStringView(f.getValue());
                                    if (this.getName().equalsIgnoreCase("id")) {
                                        view.getWidget().addClickHandler((ClickHandler)new EditLinkListener(t.getTitleId(), UiAssetTableDataProvider.this.view));
                                        view.setStyleName("table-data-link");
                                    }
                                    return view;
                                }
                                return new LabelStringView("ERROR: Value not available");
                            }
                        };
                        UiAssetTableDataProvider.this.columns.add(column);
                        if (column.getName().equals(table.getDefaultSortColumnName())) {
                            UiAssetTableDataProvider.this.defaultSortColumn = (Column)column;
                        }
                        if (!uiColumn.isSortable()) continue;
                        UiAssetTableDataProvider.this.sortableColumns.add(column);
                    }
                }
                callback.onSuccess(null);
            }
        });
    }

    public Column<?, TitleRecord> getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public SortOrder getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    public List<Column<?, TitleRecord>> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public void setSortFeature(SortFeatureImpl<Long, TitleRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        this.view.handleGetRecordsRequest();
        TitleSearchServiceAsync searchService = (TitleSearchServiceAsync)GWT.create(TitleSearchService.class);
        UITitleFilter titleFilter = this.view.getTitleFilter();
        titleFilter.setStartIndex((this.pageFeature.getPageNumber() - 1) * this.pageFeature.getPageSize());
        titleFilter.setMaxCount(this.pageFeature.getPageSize());
        if (TableColumnNameHelper.isMetdataField(this.sortFeature.getSortColumnName())) {
            titleFilter.setSortFieldMetadata(true);
            String columnName = TableColumnNameHelper.getColumnName(this.sortFeature.getSortColumnName());
            titleFilter.setSortColumnName(columnName);
            String colSection = TableColumnNameHelper.getSectionName(this.sortFeature.getSortColumnName());
            titleFilter.setSortColumnSection(colSection);
        } else {
            titleFilter.setSortFieldMetadata(false);
            titleFilter.setSortColumnName(this.sortFeature.getSortColumnName());
        }
        titleFilter.setSortOrder(this.sortFeature.isAscending() ? SortOrder.ASCENDING.name() : SortOrder.DESCENDING.name());
        searchService.getTitles(titleFilter, this.uiColumns, new AsyncCallback<UiTitleList>(){

            public void onFailure(Throwable caught) {
                UiAssetTableDataProvider.this.pageFeature.setRecordCount(-1);
                callback.onFailure(caught);
                UiAssetTableDataProvider.this.view.handleGetRecordsFailureResponse(caught);
            }

            public void onSuccess(UiTitleList result) {
                ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                for (UiTitle t : result.getTitles()) {
                    records.add(new TitleRecord(t));
                }
                UiAssetTableDataProvider.this.pageFeature.setRecordCount(result.getTotalCount());
                callback.onSuccess(records);
                UiAssetTableDataProvider.this.view.handleGetRecordsSuccessResponse(records);
            }
        });
    }

    public boolean isCheckboxEnabled() {
        return this.view.hasActions();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }
}

