/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.UISpecificationClientManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class SearchCriteriaPanel
extends VerticalContainer {
    CriteriaListingPanel criteriaListingPanel;
    UIAssetSpecification specification;
    private final String specificationName;
    private SimpleContainer wrapperPanel;
    private BusyIndicator busyIndicator = new BusyIndicator();

    public SearchCriteriaPanel(String specificationName) {
        this.specificationName = specificationName;
        this.initialize();
        this.loadSpecification();
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    private void initialize() {
        this.busyIndicator.center();
        this.wrapperPanel = new SimpleContainer();
        this.wrapperPanel.setStyleName("advanced-search-background");
        LabelWidget label = new LabelWidget("");
        this.wrapperPanel.setWidget((Widget)label);
        this.add((Widget)this.wrapperPanel);
    }

    private void loadSpecification() {
        if (this.specification != null) {
            this.handleLoadSpecificationSuccess(this.specification);
            this.busyIndicator.hide();
            return;
        }
        UISpecificationClientManager specManagerService = UISpecificationClientManager.getInstance();
        specManagerService.get(this.specificationName, (AsyncCallback)new NeptuneAsyncCallback<UIAssetSpecification>(){

            public void onNeptuneFailure(Throwable caught) {
                SearchCriteriaPanel.this.busyIndicator.hide();
                SearchCriteriaPanel.this.handleLoadSpecificationFailure(caught);
            }

            public void onNeptuneSuccess(UIAssetSpecification result) {
                SearchCriteriaPanel.this.setSpecification(result);
                SearchCriteriaPanel.this.handleLoadSpecificationSuccess(result);
                SearchCriteriaPanel.this.busyIndicator.hide();
            }
        });
    }

    private void handleLoadSpecificationSuccess(UIAssetSpecification specification) {
        this.criteriaListingPanel = new CriteriaListingPanel(null, specification, new SearchOperator());
        this.wrapperPanel.setWidget((Widget)this.criteriaListingPanel);
    }

    private void handleLoadSpecificationFailure(Throwable error) {
        Window.alert((String)"Failed to load the specification from the server.");
    }

    public PredicateList getDataList() {
        return this.criteriaListingPanel != null ? this.criteriaListingPanel.getRoot() : null;
    }

    public void reset() {
        this.criteriaListingPanel = null;
        this.wrapperPanel.setWidget((Widget)new LabelWidget(""));
        this.busyIndicator.center();
        this.loadSpecification();
    }

    public UIAssetSpecification getSpecification() {
        return this.specification;
    }

    private void setSpecification(UIAssetSpecification specification) {
        this.specification = specification;
    }

    public boolean validate() {
        if (this.criteriaListingPanel == null) {
            return false;
        }
        if (this.criteriaListingPanel.getRoot().isEmpty()) {
            return true;
        }
        return this.criteriaListingPanel.validate();
    }
}

