/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.titlelist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.client.model.UiTitleLists;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.TitleListsPanel;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListKey;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class TitleListsDataProvider
implements DataProvider<UiTitleListKey, UiTitleListRecord> {
    private final List<Column<?, UiTitleListRecord>> columns;
    private final ColumnBase<String, UiTitleListRecord> idColumn;
    private final ColumnBase<String, UiTitleListRecord> nameColumn;
    ITitleListServiceAsync titleListService = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<UiTitleListKey, UiTitleListRecord> parentSortFeature;
    private static String ID_COLUMN = "id";
    private static String NAME_COLUMN = "name";
    private TitleListsPanel listsPanel;

    public TitleListsDataProvider(TitleListsPanel listsPanel) {
        this.listsPanel = listsPanel;
        this.columns = new ArrayList();
        this.idColumn = new ColumnBase<String, UiTitleListRecord>(ID_COLUMN, this.constants.titleListIdColumn()){

            public View<String> getView(UiTitleListRecord record) {
                return new LabelStringView(String.valueOf(record.getKey().getId()));
            }
        };
        this.columns.add((Column<?, UiTitleListRecord>)this.idColumn);
        this.nameColumn = new ColumnBase<String, UiTitleListRecord>(NAME_COLUMN, this.constants.titleListNameColumn()){

            public View<String> getView(UiTitleListRecord record) {
                return new LabelStringView(record.getTitleList().getName());
            }
        };
        this.columns.add((Column<?, UiTitleListRecord>)this.nameColumn);
    }

    public ColumnBase<String, UiTitleListRecord> getDefaultSortColumn() {
        return this.idColumn;
    }

    public List<Column<?, UiTitleListRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiTitleListRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(UiTitleListKey key, final AsyncCallback<UiTitleListRecord> callback) {
        this.titleListService.get(key.getId(), (AsyncCallback<UiTitleList>)new NeptuneAsyncCallback<UiTitleList>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTitleList result) {
                callback.onSuccess((Object)new UiTitleListRecord(result));
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiTitleListRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.titleListService.getTitlelists(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), (AsyncCallback<UiTitleLists>)new NeptuneAsyncCallback<UiTitleLists>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleListsDataProvider.this.getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTitleLists result) {
                TitleListsDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                callback.onSuccess(this.prepareUIObjects(result));
            }

            private List<UiTitleListRecord> prepareUIObjects(UiTitleLists result) {
                ArrayList<UiTitleListRecord> records = new ArrayList<UiTitleListRecord>();
                for (UiTitleList list : result.getLists()) {
                    records.add(new UiTitleListRecord(list));
                }
                return records;
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return this.listsPanel.hasActions();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<UiTitleListKey, UiTitleListRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<UiTitleListKey, UiTitleListRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }
}

