/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.service.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIAssetDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;

class UIAssetBuilder
implements IUIAssetDefinitionVisitor {
    private transient UIAsset builtAsset = null;
    private transient boolean buildRequiredChildren = true;

    public UIAsset build(UIAssetDefinition assetDefinition) {
        return this.build(assetDefinition, true);
    }

    public UIAsset build(UIAssetDefinition assetDefinition, boolean buildChildren) {
        this.buildRequiredChildren = buildChildren;
        assetDefinition.accept((IUIAssetDefinitionVisitor)this);
        return this.getBuiltAsset();
    }

    public void visit(UIGroupAssetDefinition assetDefinition) {
        UIGroupAsset asset = new UIGroupAsset();
        asset.setAssetType(assetDefinition.getAssetType());
        if (this.buildRequiredChildren) {
            for (UIAssetDefinition childDefinition : assetDefinition.getChildren()) {
                int requiredCount = childDefinition.getMinimumCount();
                int i = 0;
                while (i < requiredCount) {
                    UIAsset childAsset = this.build(childDefinition);
                    asset.addChild(childAsset);
                    ++i;
                }
            }
        }
        this.builtAsset = asset;
    }

    public void visit(UIItemAssetDefinition assetDefinition) {
        UIItemAsset asset = new UIItemAsset();
        asset.setAssetType(assetDefinition.getAssetType());
        this.builtAsset = asset;
    }

    private UIAsset getBuiltAsset() {
        UIAsset asset = this.builtAsset;
        this.builtAsset = null;
        this.buildRequiredChildren = true;
        return asset;
    }
}

