/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.service.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetBuilder;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFileBuilder;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIFieldBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import java.util.List;

public class UIAssetFactory
implements IUIAssetFactory {
    @Override
    public UIAsset createAsset(UIAssetSpecification specification) {
        return this.create(specification, null);
    }

    @Override
    public UIAsset createAsset(UIAssetSpecification specification, String rootAssetType) {
        if (rootAssetType == null) {
            throw new RuntimeException("The root asset type cannot be null.");
        }
        return this.create(specification, rootAssetType);
    }

    @Override
    public UIAsset createAsset(UIAssetDefinition assetDefinition) {
        return this.createAsset(assetDefinition, false);
    }

    @Override
    public UIAsset createAsset(UIAssetDefinition assetDefinition, boolean buildChildren) {
        UIAssetBuilder builder = new UIAssetBuilder();
        return builder.build(assetDefinition, buildChildren);
    }

    @Override
    public UIField createAssetField(UIFieldDefinition fieldDefinition) {
        return this.createAssetField(fieldDefinition, false);
    }

    @Override
    public UIField createAssetField(UIFieldDefinition fieldDefinition, boolean buildChildren) {
        UIFieldBuilder builder = new UIFieldBuilder();
        return builder.build(fieldDefinition, buildChildren);
    }

    @Override
    public UIAssetFile createAssetFile(UIAssetFileDefinition fileDefinition) {
        UIAssetFileBuilder builder = new UIAssetFileBuilder();
        return builder.build(fileDefinition);
    }

    @Override
    public UIAssetFileField createAssetFileField(UIAssetFileFieldDefinition fieldDefinition) {
        UIAssetFileBuilder builder = new UIAssetFileBuilder();
        return builder.build(fieldDefinition);
    }

    private UIAsset create(UIAssetSpecification specification, String assetType) {
        UIAssetDefinition matchingRoot = null;
        List definitions = specification.getAssetDefinitions();
        for (UIAssetDefinition definition : definitions) {
            if (assetType != null && !assetType.equals(definition.getAssetType())) continue;
            matchingRoot = definition;
            break;
        }
        if (matchingRoot == null) {
            String msg = "Failed to find a root asset definition for the provided specification.";
            throw new RuntimeException(msg);
        }
        return this.createAsset(matchingRoot, true);
    }
}

