/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleStatus;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManagerAsync;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.UISpecificationClientManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.List;

public class TitleViewInput {
    private String specificationName;
    private NeptuneSecurity security;
    private Long requestKey;
    private boolean selectButtonVisible;
    private String action;
    private String listOfAssetIds;
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private IUISpecificationManagerAsync specService = UISpecificationClientManager.getInstance();
    private UIAssetSpecification specification = null;
    private UITitle title = null;
    private List<UIAssetFilePath> filePaths;

    public TitleViewInput(NeptuneSecurity security, String specificationName) {
        this(security, specificationName, null);
    }

    public TitleViewInput(NeptuneSecurity security, String specificationName, Long titleId) {
        this.security = security;
        this.title = new UITitle();
        this.specificationName = specificationName;
        this.title.setId(titleId);
    }

    public TitleViewInput(NeptuneSecurity security, String specificationName, Long titleId, Long requestKey, String action, String listOfAssetIds, boolean selectButtonVisible) {
        this(security, specificationName, titleId);
        this.requestKey = requestKey;
        this.selectButtonVisible = selectButtonVisible;
        this.action = action;
        this.listOfAssetIds = listOfAssetIds;
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public boolean hasTitleReadPermission() {
        return this.security.isUserInRole("AssetManagement_View");
    }

    public boolean hasTitleModifyPermission() {
        return this.security.isUserInRole("AssetManagement_Modify");
    }

    public boolean hasTitleCreatePermission() {
        return this.security.isUserInRole("AssetManagement_Create");
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    void setSpecificationName(String specificationName) {
        if (!this.isEqual(specificationName, this.specificationName)) {
            this.specificationName = specificationName;
            this.invalidateSpecification();
        }
    }

    public UIAssetSpecification getSpecification() {
        return this.specification;
    }

    public void getSpecification(final AsyncCallback<UIAssetSpecification> callback) {
        if (this.specification != null) {
            callback.onSuccess((Object)this.specification);
        } else {
            NeptuneAsyncCallback<UIAssetSpecification> innerCallback = new NeptuneAsyncCallback<UIAssetSpecification>(){

                public void onNeptuneFailure(Throwable caught) {
                    TitleViewInput.this.handleGetSpecificationFailure(caught, (AsyncCallback<UIAssetSpecification>)callback);
                }

                public void onNeptuneSuccess(UIAssetSpecification result) {
                    TitleViewInput.this.handleGetSpecificationSuccess(result, (AsyncCallback<UIAssetSpecification>)callback);
                }
            };
            if (this.specificationName != null) {
                this.specService.get(this.specificationName, (AsyncCallback)innerCallback);
            } else {
                this.specService.getDefault((AsyncCallback)innerCallback);
            }
        }
    }

    private void handleGetSpecificationFailure(Throwable caught, AsyncCallback<UIAssetSpecification> callback) {
        callback.onFailure(caught);
    }

    private void handleGetSpecificationSuccess(UIAssetSpecification result, AsyncCallback<UIAssetSpecification> callback) {
        this.specification = result;
        callback.onSuccess((Object)result);
    }

    public void invalidateSpecification() {
        this.specification = null;
    }

    public Long getTitleId() {
        return this.title.getId();
    }

    void updateTitle(UITitle title) {
        if (this.getTitleId() == null) {
            this.title.setId(title.getId());
        }
        this.invalidateTitle();
        this.title.setMetadata(title.getMetadata());
        this.title.setHistory(title.getHistory());
    }

    public void invalidateTitle() {
        this.invalidateMetadata();
        this.invalidateHistory();
        this.invalidateFilePaths();
    }

    public UITitleMetadata getMetadata() {
        return this.title.getMetadata();
    }

    public void getMetadata(final AsyncCallback<UITitleMetadata> callback) {
        Long titleId = this.title.getId();
        UITitleMetadata cachedMetadata = this.title.getMetadata();
        if (cachedMetadata != null) {
            callback.onSuccess((Object)cachedMetadata);
        } else if (titleId != null) {
            this.viewService.getTitleMetadata(titleId, (AsyncCallback<UITitleMetadata>)new NeptuneAsyncCallback<UITitleMetadata>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UITitleMetadata result) {
                    TitleViewInput.this.title.setMetadata(result);
                    callback.onSuccess((Object)result);
                }
            });
        } else {
            this.getSpecification((AsyncCallback<UIAssetSpecification>)new NeptuneAsyncCallback<UIAssetSpecification>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UIAssetSpecification result) {
                    UITitleMetadata metadata = new UITitleMetadata();
                    UIAssetFactory assetFactory = new UIAssetFactory();
                    UIAsset rootAsset = assetFactory.createAsset(result);
                    metadata.setRootAsset(rootAsset);
                    metadata.setTitleStatus(UITitleStatus.DRAFT);
                    TitleViewInput.this.title.setMetadata(metadata);
                    callback.onSuccess((Object)metadata);
                }
            });
        }
    }

    public void invalidateMetadata() {
        this.title.setMetadata(null);
    }

    public UITitleHistory getHistory() {
        return this.title.getHistory();
    }

    public void getHistory(final AsyncCallback<UITitleHistory> callback) {
        Long titleId = this.title.getId();
        UITitleHistory history = this.title.getHistory();
        if (history != null) {
            callback.onSuccess((Object)history);
        } else if (titleId != null) {
            this.viewService.getTitleHistory(titleId, (AsyncCallback<UITitleHistory>)new NeptuneAsyncCallback<UITitleHistory>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UITitleHistory result) {
                    TitleViewInput.this.title.setHistory(result);
                    callback.onSuccess((Object)result);
                }
            });
        } else {
            history = new UITitleHistory();
            this.title.setHistory(history);
            callback.onSuccess((Object)history);
        }
    }

    public void invalidateHistory() {
        this.title.setHistory(null);
    }

    public Long getRequestKey() {
        return this.requestKey;
    }

    public String getAction() {
        return this.action;
    }

    public String getListOfAssetIds() {
        return this.listOfAssetIds;
    }

    public boolean isSelectButtonVisible() {
        return this.selectButtonVisible;
    }

    public List<UIAssetFilePath> getFilePaths() {
        return this.filePaths;
    }

    public void getFilePaths(final AsyncCallback<List<UIAssetFilePath>> callback) {
        if (this.filePaths != null) {
            callback.onSuccess(this.filePaths);
        } else {
            this.viewService.getAvailableFilePaths((AsyncCallback<List<UIAssetFilePath>>)new NeptuneAsyncCallback<List<UIAssetFilePath>>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(List<UIAssetFilePath> result) {
                    TitleViewInput.this.filePaths = result;
                    callback.onSuccess(result);
                }
            });
        }
    }

    public void invalidateFilePaths() {
        this.filePaths = null;
    }

    private boolean isEqual(Object value1, Object value2) {
        return value1 == value2 || value1 != null && value1.equals(value2);
    }
}

