/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import java.util.ArrayList;
import java.util.List;

public abstract class ComplexFieldGroupWidget
extends Composite {
    private UIComplexFieldDefinition fieldDefinition;
    private boolean readOnly = false;
    private AssetTree.AssetInfo parentAsset;
    private UIComplexField parentField;
    private TitleViewMessages messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);

    public ComplexFieldGroupWidget(UIComplexFieldDefinition fieldDefinition, boolean readOnly) {
        this.fieldDefinition = fieldDefinition;
        this.readOnly = readOnly;
    }

    public void setInput(AssetTree.AssetInfo asset, UIComplexField parentField) {
        this.parentAsset = asset;
        this.parentField = parentField;
        this.refresh();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public UIComplexFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public AssetTree.AssetInfo getParentAsset() {
        return this.parentAsset;
    }

    public UIComplexField getParentField() {
        return this.parentField;
    }

    protected List<UIComplexField> getFields() throws MetadataTypeMismatchException {
        if (this.parentField == null) {
            return null;
        }
        ArrayList<UIComplexField> inputFields = new ArrayList<UIComplexField>();
        String name = this.fieldDefinition.getName();
        for (UIField field : this.parentField.getChildren().getFields(name)) {
            if (field instanceof UIComplexField) {
                inputFields.add((UIComplexField)field);
                continue;
            }
            throw new MetadataTypeMismatchException(name, (UIFieldDefinition)this.fieldDefinition, field);
        }
        return inputFields;
    }

    protected int getFieldCount() {
        String fieldName = this.getFieldDefinition().getName();
        int fieldCount = 0;
        if (this.getParentField() != null) {
            fieldCount = this.getParentField().getChildren().getFieldCount(fieldName);
        }
        return fieldCount;
    }

    protected TitleViewMessages getViewMessages() {
        return this.messages;
    }

    public abstract void refresh();

    public abstract void validate(List<AssetValidationMessage> var1);

    public abstract void reportMismatchError(MetadataTypeMismatchException var1);

    protected Widget buildMetadataMismatchErrorWidget(MetadataTypeMismatchException mtme) {
        String typeName = this.getFieldTypeName(mtme.getFieldDefinition());
        String receivedTypeName = this.getFieldTypeName(mtme.getReceivedField());
        String message = this.getViewMessages().metadataTypeMismatchError(typeName, receivedTypeName);
        LabelWidget label = new LabelWidget(message);
        label.addStyleName("fieldLabel-datatypeError");
        return label;
    }

    private String getFieldTypeName(UIFieldDefinition fieldDefinition) {
        String name = null;
        name = fieldDefinition instanceof UIComplexFieldDefinition ? this.messages.complexTypeName() : (fieldDefinition instanceof UISimpleFieldDefinition ? ((UISimpleFieldDefinition)fieldDefinition).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    private String getFieldTypeName(UIField field) {
        String name = null;
        name = field instanceof UIComplexField ? this.messages.complexTypeName() : (field instanceof UISimpleField ? ((UISimpleField)field).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }
}

