/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileURIConverter;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileURIOracle;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileURIWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.DataTypeWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedSuggestBoxWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedTextBoxWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.IValueConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.BooleanWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DateWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.FloatWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.IntegerWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;

public class FileDataTypeWidgetFactory
extends DefaultDataTypeWidgetFactory {
    private TitleViewMessages messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
    private UIAssetFile file;

    public DataTypeWidget<Boolean> createBooleanWidget(BooleanWidgetConfiguration configuration) {
        DataTypeWidget widget = super.createBooleanWidget(configuration);
        this.updateWidgetVisibleLength(widget, 20);
        return widget;
    }

    public DataTypeWidget<Long> createIntegerWidget(IntegerWidgetConfiguration configuration) {
        DataTypeWidget widget = super.createIntegerWidget(configuration);
        this.updateWidgetVisibleLength(widget, 15);
        return widget;
    }

    public DataTypeWidget<String> createFloatWidget(FloatWidgetConfiguration configuration) {
        DataTypeWidget widget = super.createFloatWidget(configuration);
        this.updateWidgetVisibleLength(widget, 15);
        return widget;
    }

    public DataTypeWidget<String> createDateWidget(DateWidgetConfiguration configuration) {
        DataTypeWidget widget = super.createDateWidget(configuration);
        this.updateWidgetVisibleLength(widget, 15);
        return widget;
    }

    public DataTypeWidget<String> createTimeWidget(TimeWidgetConfiguration configuration) {
        DataTypeWidget widget = super.createTimeWidget(configuration);
        this.updateWidgetVisibleLength(widget, 10);
        return widget;
    }

    public DataTypeWidget<String> createStringWidget(StringWidgetConfiguration configuration) {
        DataTypeWidget stringWidget = null;
        if (configuration instanceof FileURIWidgetConfiguration) {
            FileURIWidgetConfiguration fileConfiguration = (FileURIWidgetConfiguration)configuration;
            FileURIOracle oracle = new FileURIOracle(this.file);
            if (fileConfiguration.getFilePaths() != null) {
                oracle.addAll(fileConfiguration.getFilePaths());
            }
            TypedSuggestBoxWidget widget = new TypedSuggestBoxWidget((IValueConverter)new FileURIConverter(), (SuggestOracle)oracle);
            widget.setLimit(20);
            widget.setToolTip(this.messages.fileURIWidgetToolTip());
            widget.setErrorToolTip(this.messages.fileURIWidgetErrorToolTip());
            ((TextBox)widget.getTextBox()).setVisibleLength(50);
            stringWidget = widget;
        } else {
            stringWidget = super.createStringWidget(configuration);
            this.updateWidgetVisibleLength(stringWidget, 15);
        }
        return stringWidget;
    }

    private void updateWidgetVisibleLength(DataTypeWidget<?> widget, int length) {
        if (widget instanceof TypedTextBoxWidget) {
            ((TypedTextBoxWidget)widget).setVisibleLength(length);
        }
    }

    public UIAssetFile getFile() {
        return this.file;
    }

    public void setFile(UIAssetFile file) {
        this.file = file;
    }
}

